/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.codestory.http.routes.CatchAllRoute;
import net.codestory.http.routes.Route;
import net.codestory.http.routes.RouteWithPattern;

public class RouteSorter {
    private final Map<RouteWithPattern, RouteWithPattern> userRoutes = new HashMap<RouteWithPattern, RouteWithPattern>();
    private final Map<CatchAllRoute, CatchAllRoute> catchAllRoutes = new HashMap<CatchAllRoute, CatchAllRoute>();
    private final List<Route> staticRoutes = new LinkedList<Route>();

    public void addUserRoute(RouteWithPattern route) {
        this.userRoutes.put(route, route);
    }

    public void addCatchAllRoute(CatchAllRoute route) {
        this.catchAllRoutes.put(route, route);
    }

    public void addStaticRoute(Route route) {
        this.staticRoutes.add(route);
    }

    public Route[] getSortedRoutes() {
        ArrayList sorted = new ArrayList();
        this.userRoutes.values().stream().sorted((left, right) -> left.uriParser().compareTo(right.uriParser())).forEach(sorted::add);
        this.staticRoutes.forEach(sorted::add);
        this.catchAllRoutes.values().stream().sorted((left, right) -> right.getMethod().compareTo(left.getMethod())).forEach(sorted::add);
        return sorted.toArray(new Route[sorted.size()]);
    }
}

