/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import net.codestory.http.Context;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Strings;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;

class BoundFolderRoute
implements Route {
    private final String uriRoot;
    private final File root;

    public BoundFolderRoute(String uriRoot, File root) {
        this.uriRoot = BoundFolderRoute.addLeadingSlash(uriRoot);
        this.root = root;
    }

    @Override
    public boolean matchUri(String uri) {
        return uri.startsWith(this.uriRoot);
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Payload body(Context context) throws IOException {
        File file = new File(this.root, Strings.substringAfter(context.uri(), this.uriRoot));
        if (!this.isPublic(file)) {
            return Payload.notFound();
        }
        try (FileInputStream from = new FileInputStream(file);){
            Payload payload = new Payload(ContentTypes.get(file.getName()), InputStreams.readBytes(from));
            return payload;
        }
    }

    public boolean isPublic(File file) {
        for (Path part : file.toPath()) {
            if (!"..".equals(part.toString()) && !part.toString().startsWith("_")) continue;
            return false;
        }
        return file.exists();
    }

    private static String addLeadingSlash(String uriRoot) {
        return uriRoot.endsWith("/") ? uriRoot : uriRoot + "/";
    }
}

