/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import net.codestory.http.Cookie;
import net.codestory.http.Cookies;
import net.codestory.http.internal.SimpleCookie;
import org.simpleframework.http.Request;

class SimpleCookies
implements Cookies {
    private final Request request;

    SimpleCookies(Request request) {
        this.request = request;
    }

    @Override
    public Iterator<Cookie> iterator() {
        return this.request.getCookies().stream().map(SimpleCookie::new).iterator();
    }

    @Override
    public SimpleCookie get(String name) {
        org.simpleframework.http.Cookie cookie = this.request.getCookie(name);
        return cookie == null ? null : new SimpleCookie(cookie);
    }

    @Override
    public String value(String name) {
        org.simpleframework.http.Cookie cookie = this.request.getCookie(name);
        return cookie == null ? null : cookie.getValue();
    }

    @Override
    public Map<String, String> keyValues() {
        return this.request.getCookies().stream().collect(Collectors.toMap(org.simpleframework.http.Cookie::getName, org.simpleframework.http.Cookie::getValue));
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return (T)(type.isInstance(this.request) ? this.request : null);
    }
}

