/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.websockets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public enum WebSocketJsonParser {
    INSTANCE;

    private final ObjectMapper objectMapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public byte[] toJson(Object object) {
        try {
            return this.objectMapper.writeValueAsBytes(object);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to write as json", e);
        }
    }

    public <T> T as(String text, Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(text, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse json", e);
        }
    }
}

