/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.codestory.http.io.ClassPaths;

public class ClasspathScanner {
    private static final String DOT_CLASS = ".class";

    public Set<String> getResources(String prefix) {
        return this.listPaths(prefix, path -> !path.endsWith(DOT_CLASS));
    }

    public Set<Class<?>> getTypesAnnotatedWith(String packageToScan, Class<? extends Annotation> annotation) {
        LinkedHashSet classes = new LinkedHashSet();
        new FastClasspathScanner(new String[]{packageToScan}).matchClassesWithAnnotation(annotation, classes::add).scan();
        return classes;
    }

    public Set<String> listPaths(String prefix, Predicate<String> filter) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        for (URL url : ClasspathScanner.urls(prefix)) {
            for (String rawPath : ClassPaths.fromURL(url)) {
                String path = rawPath.replace('\\', '/');
                if (!path.startsWith(prefix) || !filter.test(path)) continue;
                paths.add(path);
            }
        }
        return paths;
    }

    private static Set<URL> urls(String name) {
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String externalForm = url.toExternalForm().replace('\\', '/');
                int index = externalForm.lastIndexOf(name);
                if (index != -1) {
                    result.add(new URL(externalForm.substring(0, index)));
                    continue;
                }
                result.add(url);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

