/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating.helpers;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class EachReverseHelperSource {
    public CharSequence each_reverse(Object context, Options options) throws IOException {
        if (context == null) {
            return "";
        }
        return context instanceof Iterable ? this.iterableContext((Iterable)context, options) : this.hashContext(context, options);
    }

    private CharSequence hashContext(Object context, Options options) throws IOException {
        StringBuilder buffer = new StringBuilder();
        Context parent = options.context;
        Iterator iterator = EachReverseHelperSource.reverse(options.propertySet(context));
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Context current = Context.newContext((Context)parent, entry.getValue()).data("key", entry.getKey());
            buffer.append(options.fn((Object)current));
        }
        return buffer;
    }

    private CharSequence iterableContext(Iterable<?> context, Options options) throws IOException {
        if (options.isFalsy(context)) {
            return options.inverse();
        }
        StringBuilder buffer = new StringBuilder();
        Iterator<?> iterator = EachReverseHelperSource.reverse(context);
        int index = 0;
        Context parent = options.context;
        while (iterator.hasNext()) {
            Object element = iterator.next();
            boolean first = index == 0;
            boolean even = index % 2 == 0;
            boolean last = !iterator.hasNext();
            Context current = Context.newContext((Context)parent, element).data("index", (Object)index).data("first", (Object)(first ? "first" : "")).data("last", (Object)(last ? "last" : "")).data("odd", (Object)(even ? "" : "odd")).data("even", (Object)(even ? "even" : ""));
            buffer.append(options.fn((Object)current));
            ++index;
        }
        return buffer;
    }

    private static <T> Iterator<T> reverse(Iterable<T> values) {
        LinkedList<T> reversed = new LinkedList<T>();
        for (T value : values) {
            reversed.add(value);
        }
        return reversed.descendingIterator();
    }
}

