/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.auth;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.codestory.http.Context;
import net.codestory.http.Cookie;
import net.codestory.http.NewCookie;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.filters.auth.AuthData;
import net.codestory.http.payload.Payload;
import net.codestory.http.security.SessionIdStore;
import net.codestory.http.security.User;
import net.codestory.http.security.Users;

public class CookieAuthFilter
implements Filter {
    protected static final String[] DEFAULT_EXCLUDE = new String[]{".less", ".css", ".map", ".js", ".coffee", ".ico", ".jpeg", ".jpg", ".gif", ".png", ".svg", ".eot", ".ttf", ".woff", "woff2", "robots.txt"};
    protected static final Random RANDOM = new Random();
    protected static final int ONE_DAY = (int)TimeUnit.DAYS.toSeconds(1L);
    protected final String uriPrefix;
    protected final Users users;
    protected final SessionIdStore sessionIdStore;
    protected final String[] ignoreExtensions;

    public CookieAuthFilter(String uriPrefix, Users users) {
        this(uriPrefix, users, SessionIdStore.inMemory(), DEFAULT_EXCLUDE);
    }

    public CookieAuthFilter(String uriPrefix, Users users, SessionIdStore sessionIdStore) {
        this(uriPrefix, users, sessionIdStore, DEFAULT_EXCLUDE);
    }

    public CookieAuthFilter(String uriPrefix, Users users, SessionIdStore sessionIdStore, String ignoreExtension, String ... moreIgnoreExtensions) {
        this(uriPrefix, users, sessionIdStore, (String[])Stream.concat(Stream.of(ignoreExtension), Stream.of(moreIgnoreExtensions)).toArray(String[]::new));
    }

    private CookieAuthFilter(String uriPrefix, Users users, SessionIdStore sessionIdStore, String[] ignoreExtensions) {
        this.uriPrefix = uriPrefix;
        this.users = users;
        this.sessionIdStore = sessionIdStore;
        this.ignoreExtensions = ignoreExtensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(String uri, Context context) {
        if (uri.startsWith("/auth/")) return true;
        if (!uri.startsWith(this.uriPrefix)) return false;
        if (!Stream.of(this.ignoreExtensions).noneMatch(uri::endsWith)) return false;
        return true;
    }

    @Override
    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws Exception {
        return uri.startsWith("/auth/") ? this.authenticationUri(uri, context, nextFilter) : this.otherUri(uri, context, nextFilter);
    }

    protected Payload authenticationUri(String uri, Context context, PayloadSupplier nextFilter) throws Exception {
        String method = context.method();
        if (uri.startsWith("/auth/signin") && "POST".equals(method)) {
            return this.signin(context);
        }
        if (uri.startsWith("/auth/signout") && "GET".equals(method)) {
            return this.signout(context);
        }
        return nextFilter.get();
    }

    protected Payload otherUri(String uri, Context context, PayloadSupplier nextFilter) throws Exception {
        String login;
        String sessionId = this.readSessionIdInCookie(context);
        if (sessionId != null && (login = this.sessionIdStore.getLogin(sessionId)) != null) {
            User user = this.users.find(login);
            context.setCurrentUser(user);
            return nextFilter.get().withHeader("Cache-Control", "must-revalidate");
        }
        if (this.redirectToLogin(uri)) {
            return Payload.seeOther("/auth/login").withCookie(this.authCookie(this.buildCookie(null, uri)));
        }
        return new Payload(401);
    }

    protected boolean redirectToLogin(String uri) {
        return true;
    }

    protected Payload signin(Context context) {
        String password;
        String login = context.get("login");
        User user = this.users.find(login, password = context.get("password"));
        if (user == null) {
            return Payload.seeOther("/auth/login");
        }
        return Payload.seeOther(this.validRedirectUrl(this.readRedirectUrlInCookie(context))).withCookie(this.authCookie(this.buildCookie(user, "/")));
    }

    protected Payload signout(Context context) {
        String sessionId = this.readSessionIdInCookie(context);
        if (sessionId != null) {
            this.sessionIdStore.remove(sessionId);
        }
        return Payload.seeOther("/?signout").withCookie(this.authCookie(null));
    }

    protected String readSessionIdInCookie(Context context) {
        AuthData authData = this.readAuthCookie(context);
        return authData == null ? null : authData.sessionId;
    }

    protected String readRedirectUrlInCookie(Context context) {
        AuthData authData = this.readAuthCookie(context);
        String redirectUrl = authData == null ? null : authData.redirectAfterLogin;
        redirectUrl = redirectUrl == null ? "/" : redirectUrl;
        return redirectUrl;
    }

    protected String newSessionId(String login) {
        String sessionId = Long.toHexString(RANDOM.nextLong()) + Long.toHexString(RANDOM.nextLong());
        this.sessionIdStore.put(sessionId, login);
        return sessionId;
    }

    protected String buildCookie(User user, String redirectUrl) {
        AuthData cookie = new AuthData();
        if (user != null) {
            cookie.login = user.login();
            cookie.roles = user.roles();
            cookie.sessionId = this.newSessionId(user.login());
        }
        cookie.redirectAfterLogin = redirectUrl;
        return TypeConvert.toJson(cookie);
    }

    protected AuthData readAuthCookie(Context context) {
        try {
            return context.cookies().value(this.cookieName(), AuthData.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String cookieName() {
        return "auth";
    }

    protected int expiry() {
        return ONE_DAY;
    }

    protected String domain() {
        return null;
    }

    protected Cookie authCookie(String authData) {
        NewCookie cookie = new NewCookie(this.cookieName(), authData, "/", true);
        cookie.setExpiry(this.expiry());
        cookie.setDomain(null);
        cookie.setSecure(false);
        return cookie;
    }

    protected String validRedirectUrl(String redirectUrl) {
        return redirectUrl.contains("favicon.ico") ? "/" : redirectUrl;
    }
}

