/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.errors;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.codestory.http.payload.Payload;
import net.codestory.http.templating.ModelAndView;

public class ErrorPage {
    private final int errorCode;
    private final Throwable exception;

    public ErrorPage(int errorCode, Throwable exception) {
        this.errorCode = errorCode;
        this.exception = exception;
    }

    public Payload payload() {
        String error = this.toString(this.exception);
        String filename = this.filename();
        return new Payload("text/html", ModelAndView.of(filename, "ERROR", error), this.errorCode);
    }

    protected String filename() {
        return this.errorCode == 404 ? "404.html" : "500.html";
    }

    protected String toString(Throwable error) {
        if (error == null) {
            return "";
        }
        StringWriter string = new StringWriter();
        try (PrintWriter message = new PrintWriter(string);){
            error.printStackTrace(message);
        }
        return ((Object)string).toString();
    }
}

