/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.annotations;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Stream;
import net.codestory.http.annotations.Delete;
import net.codestory.http.annotations.Get;
import net.codestory.http.annotations.Head;
import net.codestory.http.annotations.Options;
import net.codestory.http.annotations.Post;
import net.codestory.http.annotations.Prefix;
import net.codestory.http.annotations.Put;
import net.codestory.http.misc.UrlConcat;

public class AnnotationHelper {
    private AnnotationHelper() {
    }

    public static void parseAnnotations(String urlPrefix, Class<?> resourceType, MethodAnnotationCallback callback) {
        Class<?> targetType = AnnotationHelper.unwrapIfItsAMockType(resourceType);
        String classPrefix = Optional.ofNullable(targetType.getAnnotation(Prefix.class)).map(Prefix::value).orElse("");
        for (Method method : targetType.getMethods()) {
            Stream.of(method.getAnnotationsByType(Get.class)).forEach(get -> callback.onMethod("GET", AnnotationHelper.url(urlPrefix, classPrefix, get.value()), method));
            Stream.of(method.getAnnotationsByType(Post.class)).forEach(post -> callback.onMethod("POST", AnnotationHelper.url(urlPrefix, classPrefix, post.value()), method));
            Stream.of(method.getAnnotationsByType(Put.class)).forEach(put -> callback.onMethod("PUT", AnnotationHelper.url(urlPrefix, classPrefix, put.value()), method));
            Stream.of(method.getAnnotationsByType(Delete.class)).forEach(delete -> callback.onMethod("DELETE", AnnotationHelper.url(urlPrefix, classPrefix, delete.value()), method));
            Stream.of(method.getAnnotationsByType(Head.class)).forEach(head -> callback.onMethod("HEAD", AnnotationHelper.url(urlPrefix, classPrefix, head.value()), method));
            Stream.of(method.getAnnotationsByType(Options.class)).forEach(options -> callback.onMethod("OPTIONS", AnnotationHelper.url(urlPrefix, classPrefix, options.value()), method));
        }
    }

    private static Class<?> unwrapIfItsAMockType(Class<?> type) {
        return type.getName().contains("EnhancerByMockito") || type.getName().contains("$MockitoMock$") ? type.getSuperclass() : type;
    }

    private static String url(String resourcePrefix, String classPrefix, String uri) {
        return new UrlConcat().url(resourcePrefix, classPrefix, uri);
    }

    public static interface MethodAnnotationCallback {
        public void onMethod(String var1, String var2, Method var3);
    }
}

