/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import net.codestory.http.AbstractWebServer;
import net.codestory.http.filters.log.LogRequestFilter;
import net.codestory.http.internal.Handler;
import net.codestory.http.internal.HttpServerWrapper;
import net.codestory.http.internal.SimpleServerWrapper;
import net.codestory.http.websockets.WebSocketHandler;

public class WebServer
extends AbstractWebServer<WebServer> {
    protected int threadCount = 8;
    protected int selectThreads = 1;
    protected int webSocketThreads = 10;

    public static void main(String[] args) {
        ((WebServer)new WebServer().configure(routes -> routes.filter(new LogRequestFilter()))).start();
    }

    public WebServer withThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public WebServer withSelectThreads(int selectThreads) {
        this.selectThreads = selectThreads;
        return this;
    }

    public WebServer withWebSocketThreads(int webSocketThreads) {
        this.webSocketThreads = webSocketThreads;
        return this;
    }

    @Override
    protected HttpServerWrapper createHttpServer(Handler httpHandler, WebSocketHandler webSocketHandler) {
        return new SimpleServerWrapper(httpHandler, webSocketHandler, this.threadCount, this.selectThreads, this.webSocketThreads);
    }
}

