/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.compilers.SourceFile;
import net.codestory.http.io.ClassPaths;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Env;

public class Resources
implements Serializable {
    private static final String[] TEMPLATE_EXTENSIONS = new String[]{"", ".html", ".md", ".markdown", ".txt"};
    private final Env env;

    public Resources(Env env) {
        this.env = env;
    }

    public SourceFile sourceFile(Path path) throws IOException {
        return new SourceFile(path, this.read(path, StandardCharsets.UTF_8));
    }

    public boolean isPublic(Path path) {
        for (Path part : path) {
            if (!"..".equals(part.toString()) && !part.toString().startsWith("_")) continue;
            return false;
        }
        return this.exists(path);
    }

    public Path findExistingPath(String uri) {
        Path templatePath;
        if (!uri.endsWith("/")) {
            for (String extension : TEMPLATE_EXTENSIONS) {
                templatePath = Paths.get(uri + extension, new String[0]);
                if (!this.exists(templatePath)) continue;
                return templatePath;
            }
        }
        for (String extension : TEMPLATE_EXTENSIONS) {
            Path path = templatePath = uri.equals("/") ? Paths.get(uri + "index" + extension, new String[0]) : Paths.get(uri, "index" + extension);
            if (!this.exists(templatePath)) continue;
            return templatePath;
        }
        return null;
    }

    public long lastModified(Path path) {
        String pathWithPrefix = this.withPrefix(path);
        if (this.existsInFileSystem(pathWithPrefix)) {
            return this.file(pathWithPrefix).lastModified();
        }
        File file = this.fileForClasspath(ClassPaths.getResource(pathWithPrefix));
        if (file != null) {
            return file.lastModified();
        }
        return -1L;
    }

    public boolean exists(Path path) {
        String pathWithPrefix = this.withPrefix(path);
        return this.existsInFileSystem(pathWithPrefix) || this.existsInClassPath(pathWithPrefix);
    }

    public String read(Path path, Charset charset) throws IOException {
        String pathWithPrefix = this.withPrefix(path);
        return this.existsInFileSystem(pathWithPrefix) ? this.readFile(this.file(pathWithPrefix), charset) : this.readClasspath(pathWithPrefix, charset);
    }

    public byte[] readBytes(Path path) throws IOException {
        String pathWithPrefix = this.withPrefix(path);
        return this.existsInFileSystem(pathWithPrefix) ? this.readFileBytes(this.file(pathWithPrefix)) : this.readClasspathBytes(pathWithPrefix);
    }

    public static String relativePath(Path parent, Path path) {
        return Resources.toUnixString(parent.relativize(path));
    }

    public static String toUnixString(Path path) {
        return path.toString().replace('\\', '/');
    }

    private String withPrefix(Path path) {
        return Resources.toUnixString(Paths.get(this.env.appFolder(), path.toString()));
    }

    private boolean existsInClassPath(String path) {
        URL url = ClassPaths.getResource(path);
        if (url == null) {
            return false;
        }
        File file = this.fileForClasspath(url);
        return file == null || file.isFile();
    }

    private String readClasspath(String path, Charset charset) throws IOException {
        URL url = ClassPaths.getResource(path);
        if (url == null) {
            throw new IllegalArgumentException("Classpath resource not found classpath:" + path);
        }
        File file = this.fileForClasspath(url);
        if (file != null) {
            return this.readFile(file, charset);
        }
        try (InputStream from = url.openStream();){
            String string = InputStreams.readString(from, charset);
            return string;
        }
    }

    private byte[] readClasspathBytes(String path) throws IOException {
        URL url = ClassPaths.getResource(path);
        if (url == null) {
            throw new IllegalArgumentException("Invalid file classpath: " + path);
        }
        File file = this.fileForClasspath(url);
        if (file != null) {
            if (!file.isFile()) {
                throw new IllegalArgumentException("Invalid file classpath: " + path);
            }
            return this.readFileBytes(file);
        }
        try (InputStream from = url.openStream();){
            byte[] byArray = InputStreams.readBytes(from);
            return byArray;
        }
    }

    File fileForClasspath(URL url) {
        String filename = url.getFile();
        if (filename == null || filename.contains(".jar!")) {
            return null;
        }
        try {
            String path = URLDecoder.decode(filename, "US-ASCII");
            String sourcePath = Paths.get("src/main/resources/", this.env.appFolder(), Strings.substringAfter(path, '/' + this.env.appFolder() + '/')).toString();
            File file = new File(sourcePath);
            if (file.exists()) {
                return file;
            }
            return new File(path);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid filename classpath: " + url, e);
        }
    }

    private File file(String path) {
        return new File(this.env.workingDir(), path);
    }

    private boolean existsInFileSystem(String path) {
        return this.file(path).isFile();
    }

    private String readFile(File file, Charset charset) throws IOException {
        if (!file.isFile()) {
            throw new IllegalArgumentException("Invalid file path: " + file);
        }
        try (FileInputStream from = new FileInputStream(file);){
            String string = InputStreams.readString(from, charset);
            return string;
        }
    }

    private byte[] readFileBytes(File file) throws IOException {
        if (!file.isFile()) {
            throw new IllegalArgumentException("Invalid file path: " + file);
        }
        try (FileInputStream from = new FileInputStream(file);){
            byte[] byArray = InputStreams.readBytes(from);
            return byArray;
        }
    }
}

