/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.net.BindException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import net.codestory.http.Configuration;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.internal.Handler;
import net.codestory.http.internal.HttpServerWrapper;
import net.codestory.http.logs.Logs;
import net.codestory.http.misc.Env;
import net.codestory.http.payload.Payload;
import net.codestory.http.payload.PayloadWriter;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;
import net.codestory.http.ssl.SSLContextFactory;
import net.codestory.http.websockets.WebSocketHandler;
import net.codestory.http.websockets.WebSocketListener;
import net.codestory.http.websockets.WebSocketSession;

public abstract class AbstractWebServer<T extends AbstractWebServer<T>> {
    protected static final int PORT_8080 = 8080;
    protected static final int RANDOM_PORT_START_RETRY = 30;
    protected final HttpServerWrapper server = this.createHttpServer(this::handleHttp, this::handleWebSocket);
    protected final Env env = this.createEnv();
    protected RoutesProvider routesProvider;
    protected int port = -1;

    protected AbstractWebServer() {
    }

    protected abstract HttpServerWrapper createHttpServer(Handler var1, WebSocketHandler var2);

    protected Env createEnv() {
        return new Env();
    }

    public T configure(Configuration configuration) {
        this.routesProvider = this.env.prodMode() ? RoutesProvider.fixed(this.env, configuration) : RoutesProvider.reloading(this.env, configuration);
        return (T)this;
    }

    public T startOnRandomPort() {
        for (int i = 0; i < 30; ++i) {
            try {
                return this.start(0);
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Port already in use")) continue;
                Logs.unableToBindServer(e);
                continue;
            }
            catch (Exception e) {
                Logs.unableToBindServer(e);
            }
        }
        throw new IllegalStateException("Unable to start server");
    }

    public T start() {
        return this.start(8080);
    }

    public T start(int port) {
        return this.startWithContext(port, null, false);
    }

    public T startSSL(int port, Path pathCertificate, Path pathPrivateKey) {
        return this.startSSL(port, Collections.singletonList(pathCertificate), pathPrivateKey, null);
    }

    public T startSSL(int port, List<Path> pathChain, Path pathPrivateKey) {
        return this.startSSL(port, pathChain, pathPrivateKey, null);
    }

    public T startSSL(int port, List<Path> pathChain, Path pathPrivateKey, List<Path> pathTrustAnchors) {
        SSLContext context;
        try {
            context = new SSLContextFactory().create(pathChain, pathPrivateKey, pathTrustAnchors);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read certificate or key", e);
        }
        boolean authReq = pathTrustAnchors != null;
        return this.startWithContext(port, context, authReq);
    }

    protected T startWithContext(int port, SSLContext context, boolean authReq) {
        if (this.routesProvider == null) {
            this.configure(Configuration.NO_ROUTE);
        }
        int thePort = port == 0 ? 0 : this.env.overriddenPort(port);
        try {
            Logs.mode(this.env.prodMode());
            this.port = this.server.start(thePort, context, authReq);
            Logs.started(this.port);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof BindException || e.getCause() instanceof BindException) {
                throw new IllegalStateException("Port already in use " + this.port);
            }
            throw new IllegalStateException("Unable to bind the web server on port " + this.port, e);
        }
        return (T)this;
    }

    public int port() {
        if (this.port == -1) {
            throw new IllegalStateException("The web server is not started");
        }
        return this.port;
    }

    protected void handleHttp(Request request, Response response) {
        RouteCollection routes = this.routesProvider.get();
        PayloadWriter writer = routes.createPayloadWriter(request, response);
        try {
            Payload payload = routes.apply(request, response);
            writer.writeAndClose(payload);
        }
        catch (Exception e) {
            writer.writeErrorPage(e);
        }
    }

    protected void handleWebSocket(WebSocketSession session, Request request, Response response) {
        RouteCollection routes = this.routesProvider.get();
        try {
            WebSocketListener listener = routes.createWebSocketListener(session, request, response);
            session.register(listener);
        }
        catch (Exception e) {
            throw new IllegalStateException("WebSocket error", e);
        }
    }

    public void stop() {
        try {
            this.env.folderWatcher().stop();
            this.server.stop();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to stop the web server", e);
        }
    }
}

