/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.io.IOException;
import java.net.BindException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.net.ssl.SSLContext;
import net.codestory.http.AbstractWebServer;
import net.codestory.http.Configuration;
import net.codestory.http.filters.log.LogRequestFilter;
import net.codestory.http.internal.HttpServerWrapper;
import net.codestory.http.internal.SimpleServerWrapper;
import net.codestory.http.misc.Env;
import net.codestory.http.reload.ConfigurationReloadingProxy;
import net.codestory.http.ssl.SSLContextFactory;

public class WebServer
extends AbstractWebServer {
    private final HttpServerWrapper server;
    private int port;

    public WebServer() {
        this(Configuration.NO_ROUTE);
    }

    public WebServer(Class<? extends Configuration> configuration) {
        this(new ConfigurationReloadingProxy(configuration));
    }

    public WebServer(Configuration configuration) {
        try {
            this.server = new SimpleServerWrapper(this::handle);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create http server", e);
        }
        this.configure(configuration);
    }

    public static void main(String[] args) throws Exception {
        new WebServer(routes -> routes.filter(new LogRequestFilter())).start(8080);
    }

    public WebServer startOnRandomPort() {
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            try {
                int port = 8183 + random.nextInt(10000);
                this.start(port);
                return this;
            }
            catch (Exception e) {
                LOG.error("Unable to bind server", (Throwable)e);
                continue;
            }
        }
        throw new IllegalStateException("Unable to start server");
    }

    public WebServer start() {
        return this.start(8080);
    }

    public WebServer start(int port) {
        return this.startWithContext(port, null, false);
    }

    public WebServer startSSL(int port, Path pathCertificate, Path pathPrivateKey) {
        return this.startSSL(port, Arrays.asList(pathCertificate), pathPrivateKey, null);
    }

    public WebServer startSSL(int port, List<Path> pathChain, Path pathPrivateKey) {
        return this.startSSL(port, pathChain, pathPrivateKey, null);
    }

    public WebServer startSSL(int port, List<Path> pathChain, Path pathPrivateKey, List<Path> pathTrustAnchors) {
        SSLContext context;
        try {
            context = new SSLContextFactory().create(pathChain, pathPrivateKey, pathTrustAnchors);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read certificate or key", e);
        }
        boolean authReq = pathTrustAnchors != null;
        return this.startWithContext(port, context, authReq);
    }

    protected WebServer startWithContext(int port, SSLContext context, boolean authReq) {
        this.port = Env.get().overriddenPort(port);
        try {
            LOG.info(Env.get().prodMode() ? "Production mode" : "Dev mode");
            this.server.start(this.port, context, authReq);
            LOG.info("Server started on port {}", (Object)this.port);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (BindException e) {
            throw new IllegalStateException("Port already in use " + this.port);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to bind the web server on port " + this.port, e);
        }
        return this;
    }

    public int port() {
        return this.port;
    }

    public void reset() {
        this.configure(Configuration.NO_ROUTE);
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to stop the web server", e);
        }
    }
}

