/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import net.codestory.http.Context;
import net.codestory.http.annotations.Produces;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.AnyRoute;

class ReflectionRoute
implements AnyRoute {
    private final Supplier<Object> resource;
    private final Method method;

    ReflectionRoute(Supplier<Object> resource, Method method) {
        this.resource = resource;
        this.method = method;
    }

    @Override
    public Object body(Context context, String[] pathParameters) {
        try {
            Object target = this.resource.get();
            Object[] arguments = ReflectionRoute.convert(context, pathParameters, this.method.getGenericParameterTypes());
            Object response = ReflectionRoute.invoke(target, this.method, arguments);
            Object payload = ReflectionRoute.emptyIfNull(response);
            String contentType = ReflectionRoute.findContentType(this.method);
            return new Payload(contentType, payload);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to apply route", e);
        }
    }

    static Object[] convert(Context context, String[] pathParameters, Type ... types) {
        int i;
        Object[] converted = new Object[types.length];
        for (i = 0; i < pathParameters.length; ++i) {
            converted[i] = TypeConvert.convertValue((Object)pathParameters[i], types[i]);
        }
        for (i = pathParameters.length; i < converted.length; ++i) {
            converted[i] = context.extract(types[i]);
        }
        return converted;
    }

    private static Object invoke(Object target, Method method, Object[] arguments) throws Throwable {
        try {
            method.setAccessible(true);
            return method.invoke(target, arguments);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static Object emptyIfNull(Object payload) {
        return payload == null ? "" : payload;
    }

    private static String findContentType(Method method) {
        Produces annotation = method.getAnnotation(Produces.class);
        return annotation == null ? null : annotation.value();
    }
}

