/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.codestory.http.Cookie;
import net.codestory.http.Cookies;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.internal.SimpleCookie;
import org.simpleframework.http.Request;

class SimpleCookies
implements Cookies {
    private final Request request;

    SimpleCookies(Request request) {
        this.request = request;
    }

    @Override
    public Iterator<Cookie> iterator() {
        return this.request.getCookies().stream().map(cookie -> new SimpleCookie((org.simpleframework.http.Cookie)cookie)).iterator();
    }

    @Override
    public Cookie get(String name) {
        org.simpleframework.http.Cookie cookie = this.request.getCookie(name);
        return cookie == null ? null : new SimpleCookie(cookie);
    }

    @Override
    public String value(String name) {
        Cookie cookie = this.get(name);
        return cookie == null ? null : cookie.value();
    }

    @Override
    public Map<String, String> keyValues() {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        this.request.getCookies().forEach(cookie -> keyValues.put(cookie.getName(), cookie.getValue()));
        return keyValues;
    }

    @Override
    public <T> T value(String name, T defaultValue) {
        Object value = this.value(name, defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }

    @Override
    public <T> T value(String name, Class<T> type) {
        String value = this.value(name);
        return value == null ? null : (T)TypeConvert.fromJson(value, type);
    }

    @Override
    public String value(String name, String defaultValue) {
        String value = this.value(name);
        return value == null ? defaultValue : value;
    }

    @Override
    public int value(String name, int defaultValue) {
        String value = this.value(name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    @Override
    public long value(String name, long defaultValue) {
        String value = this.value(name);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    @Override
    public boolean value(String name, boolean defaultValue) {
        String value = this.value(name);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }
}

