/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.codestory.http.Cookies;
import net.codestory.http.Part;
import net.codestory.http.Query;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.injection.IocAdapter;
import net.codestory.http.io.InputStreams;
import net.codestory.http.security.User;

public class Context {
    private final Request request;
    private final Response response;
    private final IocAdapter iocAdapter;
    private User currentUser;

    public Context(Request request, Response response, IocAdapter iocAdapter) {
        this.request = request;
        this.response = response;
        this.iocAdapter = iocAdapter;
    }

    public Request request() {
        return this.request;
    }

    public Response response() {
        return this.response;
    }

    public String uri() {
        return this.request.uri();
    }

    public Cookies cookies() {
        return this.request.cookies();
    }

    public List<Part> parts() {
        return this.request.parts();
    }

    public Query query() {
        return this.request.query();
    }

    public String get(String key) {
        return this.request.query().get(key);
    }

    public String header(String name) {
        return this.request.header(name);
    }

    public List<String> headers(String name) {
        return this.request.headers(name);
    }

    public String method() {
        return this.request.method();
    }

    public String clientAddress() {
        String forwarded = this.header("X-Forwarded-For");
        return forwarded != null ? forwarded : this.request.clientAddress().toString();
    }

    public byte[] content() {
        try {
            return InputStreams.readBytes(this.request.inputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read content", e);
        }
    }

    public String contentAsString() {
        try {
            return this.request.content();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read content", e);
        }
    }

    public <T> T contentAs(Class<T> type) {
        try {
            String json = this.request.content();
            return TypeConvert.fromJson(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable read content", e);
        }
    }

    public <T> T getBean(Class<T> type) {
        return this.iocAdapter.get(type);
    }

    public void setCurrentUser(User user) {
        this.currentUser = user;
    }

    public User currentUser() {
        return this.currentUser;
    }

    public boolean isUrlEncodedForm() {
        String contentType = this.header("Content-Type");
        return contentType != null && contentType.contains("application/x-www-form-urlencoded");
    }

    public Object extract(Type type) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isAssignableFrom(Context.class)) {
                return this;
            }
            if (clazz.isAssignableFrom(Request.class)) {
                return this.request();
            }
            if (clazz.isAssignableFrom(Response.class)) {
                return this.response();
            }
            if (clazz.isAssignableFrom(Cookies.class)) {
                return this.cookies();
            }
            if (clazz.isAssignableFrom(Query.class)) {
                return this.query();
            }
            if (clazz.isAssignableFrom(User.class)) {
                return this.currentUser();
            }
            if (clazz.isAssignableFrom(byte[].class)) {
                return this.content();
            }
            if (clazz.isAssignableFrom(String.class)) {
                return this.contentAsString();
            }
        }
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            if (List.class.isAssignableFrom((Class)rawType)) {
                Type argument;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length == 1 && (argument = actualTypeArguments[0]) instanceof Class && Part.class.isAssignableFrom((Class)argument)) {
                    return this.parts();
                }
            } else if (Map.class.isAssignableFrom((Class)rawType)) {
                return this.query().keyValues();
            }
        }
        if (this.isUrlEncodedForm()) {
            return TypeConvert.convertValue(this.query().keyValues(), type);
        }
        try {
            String json = this.request.content();
            return TypeConvert.fromJson(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable read content", e);
        }
    }
}

