/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.io.Resources;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

class StaticRoute
implements Route {
    StaticRoute() {
    }

    @Override
    public Match apply(String uri, Request request, Response response) throws IOException {
        if (uri.endsWith("/")) {
            return this.apply(uri + "index", request, response);
        }
        for (String extension : ContentTypes.TEMPLATE_EXTENSIONS) {
            Path path = Paths.get(uri + extension, new String[0]);
            Match match = this.serve(path, request, response);
            if (Match.WRONG_URL == match) continue;
            return match;
        }
        return Match.WRONG_URL;
    }

    private Match serve(Path path, Request request, Response response) throws IOException {
        if (!Resources.isPublic(path)) {
            return Match.WRONG_URL;
        }
        if (!"GET".equalsIgnoreCase(request.getMethod())) {
            return Match.WRONG_METHOD;
        }
        new Payload(path).writeTo(response);
        return Match.OK;
    }
}

