/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import net.codestory.http.annotations.Get;
import net.codestory.http.annotations.Post;
import net.codestory.http.filters.Filter;
import net.codestory.http.internal.UriParser;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.AnyRoute;
import net.codestory.http.routes.AnyRouteWithContext;
import net.codestory.http.routes.FourParamsRoute;
import net.codestory.http.routes.FourParamsRouteWithContext;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.NoParamRoute;
import net.codestory.http.routes.NoParamRouteWithContext;
import net.codestory.http.routes.OneParamRoute;
import net.codestory.http.routes.OneParamRouteWithContext;
import net.codestory.http.routes.ReflectionRoute;
import net.codestory.http.routes.ReflectionRouteWithContext;
import net.codestory.http.routes.Route;
import net.codestory.http.routes.RouteWithContextWrapper;
import net.codestory.http.routes.RouteWrapper;
import net.codestory.http.routes.Routes;
import net.codestory.http.routes.SourceMapRoute;
import net.codestory.http.routes.StaticRoute;
import net.codestory.http.routes.ThreeParamsRoute;
import net.codestory.http.routes.ThreeParamsRouteWithContext;
import net.codestory.http.routes.TwoParamsRoute;
import net.codestory.http.routes.TwoParamsRouteWithContext;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

public class RouteCollection
implements Routes {
    private final Deque<Route> routes = new LinkedList<Route>();
    private final Deque<Filter> filters = new LinkedList<Filter>();

    @Override
    public void add(Object resource) {
        this.add("", resource);
    }

    @Override
    public void add(String urlPrefix, Object resource) {
        Class<?> type = resource.getClass();
        if (resource.getClass().getName().contains("EnhancerByMockito")) {
            type = type.getSuperclass();
        }
        for (Method method : type.getMethods()) {
            int uriParamsCount;
            String uriPattern;
            int parameterCount = method.getParameterCount();
            for (Get get : (Get[])method.getDeclaredAnnotationsByType(Get.class)) {
                uriPattern = urlPrefix + get.value();
                uriParamsCount = UriParser.paramsCount(uriPattern);
                if (parameterCount == uriParamsCount) {
                    this.add("GET", RouteCollection.checkParametersCount(uriPattern, parameterCount), new ReflectionRoute(resource, method));
                    continue;
                }
                if (parameterCount == uriParamsCount + 1) {
                    this.add("GET", RouteCollection.checkParametersCount(uriPattern, parameterCount - 1), new ReflectionRouteWithContext(resource, method));
                    continue;
                }
                throw new IllegalArgumentException("Expected " + uriParamsCount + " or " + (uriParamsCount + 1) + " parameters in " + uriPattern);
            }
            for (Annotation annotation : (Post[])method.getDeclaredAnnotationsByType(Post.class)) {
                uriPattern = urlPrefix + annotation.value();
                uriParamsCount = UriParser.paramsCount(uriPattern);
                if (parameterCount == uriParamsCount) {
                    this.add("POST", RouteCollection.checkParametersCount(uriPattern, parameterCount), new ReflectionRoute(resource, method));
                    continue;
                }
                if (parameterCount == uriParamsCount + 1) {
                    this.add("POST", RouteCollection.checkParametersCount(uriPattern, parameterCount - 1), new ReflectionRouteWithContext(resource, method));
                    continue;
                }
                throw new IllegalArgumentException("Expected " + uriParamsCount + " or " + (uriParamsCount + 1) + " parameters in " + uriPattern);
            }
        }
    }

    @Override
    public void get(String uriPattern, Payload payload) {
        this.get(uriPattern, () -> payload);
    }

    @Override
    public void get(String uriPattern, NoParamRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void get(String uriPattern, OneParamRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void get(String uriPattern, TwoParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void get(String uriPattern, ThreeParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void get(String uriPattern, FourParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void get(String uriPattern, NoParamRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void get(String uriPattern, OneParamRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void get(String uriPattern, TwoParamsRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void get(String uriPattern, ThreeParamsRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void get(String uriPattern, FourParamsRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void post(String uriPattern, NoParamRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void post(String uriPattern, OneParamRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void post(String uriPattern, TwoParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void post(String uriPattern, ThreeParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void post(String uriPattern, FourParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void post(String uriPattern, NoParamRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void post(String uriPattern, OneParamRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void post(String uriPattern, TwoParamsRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void post(String uriPattern, ThreeParamsRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void post(String uriPattern, FourParamsRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void filter(Filter filter) {
        this.filters.addLast(filter);
    }

    private void add(String method, String uriPattern, AnyRoute route) {
        this.routes.addFirst(new RouteWrapper(method, uriPattern, route));
    }

    private void add(String method, String uriPattern, AnyRouteWithContext route) {
        this.routes.addFirst(new RouteWithContextWrapper(method, uriPattern, route));
    }

    public Match apply(Request request, Response response) throws IOException {
        String uri = request.getPath().getPath();
        if (uri == null) {
            return Match.WRONG_URL;
        }
        for (Filter filter : this.filters) {
            if (!filter.apply(uri, request, response)) continue;
            return Match.OK;
        }
        Match bestMatch = Match.WRONG_URL;
        ArrayList<Route> allRoutes = new ArrayList<Route>();
        allRoutes.addAll(this.routes);
        allRoutes.add(new StaticRoute());
        allRoutes.add(new SourceMapRoute());
        for (Route route : allRoutes) {
            Match match = route.apply(uri, request, response);
            if (match == Match.OK) {
                return Match.OK;
            }
            if (!match.isBetter(bestMatch)) continue;
            bestMatch = match;
        }
        return bestMatch;
    }

    private static String checkParametersCount(String uriPattern, int count) {
        if (UriParser.paramsCount(uriPattern) != count) {
            String error = count == 1 ? "1 parameter" : count + " parameters";
            throw new IllegalArgumentException("Expected " + error + " in " + uriPattern);
        }
        return uriPattern;
    }
}

