/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.twitter;

import java.io.IOException;
import java.net.URI;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.twitter.Authenticator;
import net.codestory.http.filters.twitter.TwitterAuthenticator;
import net.codestory.http.filters.twitter.User;
import org.simpleframework.http.Cookie;
import org.simpleframework.http.Query;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import twitter4j.TwitterFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterAuthFilter
implements Filter {
    private final String siteUri;
    private final String uriPrefix;
    private final Authenticator twitterAuthenticator;

    public TwitterAuthFilter(String siteUri, String uriPrefix, String oAuthKey, String oAuthSecret) {
        this.siteUri = siteUri;
        this.uriPrefix = TwitterAuthFilter.validPrefix(uriPrefix);
        this.twitterAuthenticator = TwitterAuthFilter.createAuthenticator(oAuthKey, oAuthSecret);
    }

    private static String validPrefix(String prefix) {
        return prefix.endsWith("/") ? prefix : prefix + "/";
    }

    private static Authenticator createAuthenticator(String oAuthKey, String oAuthSecret) {
        Configuration config = new ConfigurationBuilder().setOAuthConsumerKey(oAuthKey).setOAuthConsumerSecret(oAuthSecret).build();
        TwitterFactory twitterFactory = new TwitterFactory(config);
        return new TwitterAuthenticator(twitterFactory);
    }

    @Override
    public boolean apply(String uri, Request request, Response response) throws IOException {
        if (!uri.startsWith(this.uriPrefix)) {
            return false;
        }
        if (uri.equals(this.uriPrefix + "authenticate")) {
            User user;
            try {
                Query query = request.getQuery();
                String oauth_token = (String)query.get((Object)"oauth_token");
                String oauth_verifier = (String)query.get((Object)"oauth_verifier");
                user = this.twitterAuthenticator.authenticate(oauth_token, oauth_verifier);
            }
            catch (Exception e) {
                response.setCode(403);
                return true;
            }
            response.setCookie(new Cookie("userId", user.id.toString(), "/", true));
            response.setCookie(new Cookie("screenName", user.screenName, "/", true));
            response.setCookie(new Cookie("userPhoto", user.imageUrl, "/", true));
            response.setValue("Location", this.uriPrefix);
            response.setCode(303);
            response.setContentLength(0L);
            return true;
        }
        if (uri.equals(this.uriPrefix + "logout")) {
            response.setCookie(new Cookie("userId", "", "/", false));
            response.setCookie(new Cookie("screenName", "", "/", false));
            response.setCookie(new Cookie("userPhoto", "", "/", false));
            response.setValue("Location", "/");
            response.setCode(303);
            response.setContentLength(0L);
            return true;
        }
        Cookie userId = request.getCookie("userId");
        if (userId != null && !userId.getValue().isEmpty()) {
            return false;
        }
        String host = request.getValue("Host");
        String callbackUri = (host == null ? this.siteUri : "http://" + host) + this.uriPrefix + "authenticate";
        URI authenticateURI = this.twitterAuthenticator.getAuthenticateURI(callbackUri);
        response.setValue("Location", authenticateURI.toString());
        response.setCode(303);
        response.setContentLength(0L);
        return true;
    }
}

