/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class CoffeeCompiler {
    CoffeeCompiler() {
    }

    public String compile(String source) throws IOException {
        Scriptable globalScope = this.initWithCoffeeScriptScript();
        Context context = Context.enter();
        try {
            Scriptable scope = context.newObject(globalScope);
            scope.setParentScope(globalScope);
            scope.put("coffeeScriptSource", scope, (Object)source);
            String string = (String)context.evaluateString(scope, String.format("CoffeeScript.compile(coffeeScriptSource, %s);", "{bare: true}"), "JCoffeeScriptCompiler", 0, null);
            return string;
        }
        catch (JavaScriptException e) {
            throw new IOException("Unable to compile coffee", e);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable initWithCoffeeScriptScript() throws IOException {
        String coffeeScriptJs = CharStreams.toString((InputSupplier)Resources.newReaderSupplier((URL)Resources.getResource((String)"coffee/coffee-script.js"), (Charset)StandardCharsets.UTF_8));
        Context context = Context.enter();
        try {
            ScriptableObject globalScope = context.initStandardObjects();
            context.evaluateString((Scriptable)globalScope, coffeeScriptJs, "coffee-script.js", 0, null);
            ScriptableObject scriptableObject = globalScope;
            return scriptableObject;
        }
        finally {
            Context.exit();
        }
    }
}

