/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.HandlebarsCompiler;
import net.codestory.http.templating.Model;
import net.codestory.http.templating.Site;
import net.codestory.http.templating.YamlFrontMatter;
import net.codestory.http.types.ContentTypes;

public class Template {
    private final Path path;

    public Template(String url) {
        this(Paths.get(url, new String[0]));
    }

    public Template(Path path) {
        this.path = Template.findExistingPath(path);
    }

    private static Path findExistingPath(Path path) {
        for (String extension : ContentTypes.TEMPLATE_EXTENSIONS) {
            Path templatePath = Paths.get(path.toString() + extension, new String[0]);
            if (!Resources.exists(templatePath)) continue;
            return templatePath;
        }
        throw new IllegalArgumentException("Template not found " + path);
    }

    public String render() {
        return this.render(Model.of());
    }

    public String render(String key, Object value) {
        return this.render(Model.of(key, value));
    }

    public String render(String k1, Object v1, String k2, Object v2) {
        return this.render(Model.of(k1, v1, k2, v2));
    }

    public String render(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        return this.render(Model.of(k1, v1, k2, v2, k3, v3));
    }

    public String render(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        return this.render(Model.of(k1, v1, k2, v2, k3, v3, k4, v4));
    }

    public String render(Model model) {
        return this.render(model.getKeyValues());
    }

    public String render(Map<String, Object> keyValues) {
        return this.render(Site.get(), keyValues);
    }

    String render(Site site, Model model) {
        return this.render(site, model.getKeyValues());
    }

    String render(Site site, Map<String, Object> keyValues) {
        try {
            YamlFrontMatter parsedTemplate = YamlFrontMatter.parse(this.path);
            Map<String, Object> allKeyValues = Template.merge(parsedTemplate.getVariables(), keyValues);
            String content = Compiler.compile(this.path, parsedTemplate.getContent());
            String body = new HandlebarsCompiler().compile(content, site, allKeyValues);
            String layout = (String)parsedTemplate.getVariables().get("layout");
            if (layout != null) {
                for (String extension : ContentTypes.TEMPLATE_EXTENSIONS) {
                    Path layoutPath = Paths.get("_layouts", layout + extension);
                    if (!Resources.exists(layoutPath)) continue;
                    return new Template(layoutPath).render(site, allKeyValues).replace("[[body]]", body);
                }
                throw new IllegalStateException("Unable to find layout: " + layout);
            }
            return body;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to render template", e);
        }
    }

    @SafeVarargs
    private static Map<String, Object> merge(Map<String, Object> ... keyValues) {
        HashMap<String, Object> merged = new HashMap<String, Object>();
        for (Map<String, Object> keyValue : keyValues) {
            merged.putAll(keyValue);
        }
        merged.put("body", "[[body]]");
        return merged;
    }
}

