/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.Processor;
import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import net.codestory.http.io.Strings;
import org.jcoffeescript.JCoffeeScriptCompileException;
import org.jcoffeescript.JCoffeeScriptCompiler;
import org.jcoffeescript.Option;
import org.markdown4j.CodeBlockEmitter;
import org.markdown4j.ExtDecorator;
import org.markdown4j.IncludePlugin;
import org.markdown4j.Plugin;
import org.markdown4j.TablePlugin;
import org.markdown4j.WebSequencePlugin;
import org.markdown4j.YumlPlugin;

public enum Compiler {
    COFFEE{

        @Override
        String compile(String coffee) throws IOException {
            try {
                return new JCoffeeScriptCompiler(Collections.singletonList(Option.BARE)).compile(coffee);
            }
            catch (JCoffeeScriptCompileException e) {
                throw new IOException("Unable to compile coffee", e);
            }
        }
    }
    ,
    MARKDOWN{

        @Override
        String compile(String markdown) throws IOException {
            Configuration.Builder builder = Configuration.builder().forceExtentedProfile().registerPlugins(new Plugin[]{new TablePlugin(), new YumlPlugin(), new WebSequencePlugin(), new IncludePlugin()}).setDecorator((Decorator)new ExtDecorator()).setCodeBlockEmitter((BlockEmitter)new CodeBlockEmitter());
            return Processor.process((String)markdown, (Configuration)builder.build());
        }
    }
    ,
    LESS{

        @Override
        String compile(String less) throws IOException {
            try {
                return new ThreadUnsafeLessCompiler().compile(less).getCss();
            }
            catch (Less4jException e) {
                throw new IOException("Unable to compile less", e);
            }
        }
    }
    ,
    NONE{

        @Override
        String compile(String content) {
            return content;
        }
    };


    abstract String compile(String var1) throws IOException;

    public static String compile(Path path, String content) throws IOException {
        return Compiler.compilerForExtension(Compiler.extension(path)).compile(content);
    }

    private static String extension(Path path) {
        return Strings.substringAfterLast(path.toString(), ".");
    }

    private static Compiler compilerForExtension(String extension) {
        switch (extension) {
            case "less": {
                return LESS;
            }
            case "coffee": {
                return COFFEE;
            }
            case "md": 
            case "markdown": {
                return MARKDOWN;
            }
        }
        return NONE;
    }
}

