/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.convert;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import net.codestory.http.internal.Context;

public class TypeConvert {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private TypeConvert() {
    }

    public static Object[] convert(Context context, String[] values, Class<?>[] types) {
        Object[] converted = new Object[values.length + 1];
        converted[0] = TypeConvert.convert(context, types[0]);
        for (int i = 0; i < values.length; ++i) {
            converted[i + 1] = TypeConvert.convert(values[i], types[i]);
        }
        return converted;
    }

    public static Object[] convert(String[] values, Class<?>[] types) {
        Object[] converted = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            converted[i] = TypeConvert.convert(values[i], types[i]);
        }
        return converted;
    }

    public static Object convert(String value, Class<?> type) {
        return OBJECT_MAPPER.convertValue((Object)value, type);
    }

    public static Object convert(Context context, Class<?> type) {
        if (type.isAssignableFrom(Context.class)) {
            return context;
        }
        if (type.isAssignableFrom(Map.class)) {
            return context.getKeyValues();
        }
        return OBJECT_MAPPER.convertValue(context.getKeyValues(), type);
    }
}

