/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import net.codestory.http.Configuration;
import net.codestory.http.reload.ParentLastClassLoader;
import net.codestory.http.routes.Routes;

public class ConfigurationReloadingProxy
implements Configuration {
    private final String fqcn;
    private final ClassLoader parent;

    public ConfigurationReloadingProxy(Class<? extends Configuration> configuration) {
        this.fqcn = configuration.getName();
        this.parent = this.getClass().getClassLoader();
    }

    public static <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instanciate " + clazz.getName(), e);
        }
    }

    @Override
    public void configure(Routes routes) {
        try {
            ParentLastClassLoader cl = new ParentLastClassLoader("target/classes/", this.parent);
            Configuration delegate = (Configuration)ConfigurationReloadingProxy.createInstance(cl.loadClass(this.fqcn));
            delegate.configure(routes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to reload Configuration from classpath", e);
        }
    }
}

