/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.injection.IocAdapter;
import net.codestory.http.io.InputStreams;
import net.codestory.http.security.User;
import org.simpleframework.http.Cookie;
import org.simpleframework.http.Query;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

public class Context {
    private final Request request;
    private final Response response;
    private final IocAdapter iocAdapter;
    private final Query query;
    private User currentUser;

    public Context(Request request, Response response, IocAdapter iocAdapter) {
        this.request = request;
        this.response = response;
        this.iocAdapter = iocAdapter;
        this.query = request.getQuery();
    }

    public String uri() {
        return this.request.getPath().getPath();
    }

    public Cookie cookie(String name) {
        return this.request.getCookie(name);
    }

    public String cookieValue(String name) {
        Cookie cookie = this.cookie(name);
        return cookie == null ? null : cookie.getValue();
    }

    public <T> T cookieValue(String name, T defaultValue) {
        Object value = this.cookieValue(name, defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }

    public <T> T cookieValue(String name, Class<T> type) {
        String value = this.cookieValue(name);
        return value == null ? null : (T)TypeConvert.fromJson(value, type);
    }

    public String cookieValue(String name, String defaultValue) {
        String value = this.cookieValue(name);
        return value == null ? defaultValue : value;
    }

    public int cookieValue(String name, int defaultValue) {
        String value = this.cookieValue(name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public long cookieValue(String name, long defaultValue) {
        String value = this.cookieValue(name);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public boolean cookieValue(String name, boolean defaultValue) {
        String value = this.cookieValue(name);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public List<Cookie> cookies() {
        return this.request.getCookies();
    }

    public String get(String name) {
        return (String)this.query.get((Object)name);
    }

    public List<String> getAll(String name) {
        return this.query.getAll((Object)name);
    }

    public int getInteger(String name) {
        return this.query.getInteger((Object)name);
    }

    public float getFloat(String name) {
        return this.query.getFloat((Object)name);
    }

    public boolean getBoolean(String name) {
        return this.query.getBoolean((Object)name);
    }

    public String getHeader(String name) {
        return this.request.getValue(name);
    }

    public List<String> getHeaders(String name) {
        return this.request.getValues(name);
    }

    public String method() {
        return this.request.getMethod();
    }

    public Map<String, String> keyValues() {
        return this.query;
    }

    public String getClientAddress() {
        String forwarded = this.getHeader("X-Forwarded-For");
        return forwarded != null ? forwarded : this.request.getClientAddress().toString();
    }

    public Request request() {
        return this.request;
    }

    public Response response() {
        return this.response;
    }

    public byte[] content() {
        try {
            return InputStreams.readBytes(this.request.getInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read content", e);
        }
    }

    public String contentAsString() {
        try {
            return this.request.getContent();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read content", e);
        }
    }

    public <T> T contentAs(Class<T> type) {
        try {
            String json = this.request.getContent();
            return TypeConvert.fromJson(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable read content", e);
        }
    }

    public <T> T getBean(Class<T> type) {
        return this.iocAdapter.get(type);
    }

    public void setCurrentUser(User user) {
        this.currentUser = user;
    }

    public User currentUser() {
        return this.currentUser;
    }

    public boolean isUrlEncodedForm() {
        String contentType = this.getHeader("Content-Type");
        return contentType != null && contentType.contains("application/x-www-form-urlencoded");
    }

    public <T> T extract(Class<T> type) {
        if (type.isAssignableFrom(Context.class)) {
            return (T)this;
        }
        if (type.isAssignableFrom(Map.class)) {
            return (T)this.keyValues();
        }
        if (type.isAssignableFrom(Request.class)) {
            return (T)this.request();
        }
        if (type.isAssignableFrom(Response.class)) {
            return (T)this.response();
        }
        if (type.isAssignableFrom(User.class)) {
            return (T)this.currentUser();
        }
        if (type.isAssignableFrom(byte[].class)) {
            return (T)this.content();
        }
        if (type.isAssignableFrom(String.class)) {
            return (T)this.contentAsString();
        }
        if (this.isUrlEncodedForm()) {
            return TypeConvert.convertValue(this.keyValues(), type);
        }
        return this.contentAs(type);
    }
}

