/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.convert;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import java.io.IOException;
import net.codestory.http.internal.Context;

public class TypeConvert {
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).registerModule((Module)new JSR310Module()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    private TypeConvert() {
    }

    public static void overrideMapper(ObjectMapper mapper) {
        OBJECT_MAPPER = mapper;
    }

    public static Object[] convert(Context context, String[] pathParameters, Class<?> ... types) {
        int i;
        Object[] converted = new Object[types.length];
        for (i = 0; i < pathParameters.length; ++i) {
            converted[i] = TypeConvert.convertValue(pathParameters[i], types[i]);
        }
        for (i = pathParameters.length; i < converted.length; ++i) {
            converted[i] = context.extract(types[i]);
        }
        return converted;
    }

    public static <T> T fromJson(String json, Class<T> type) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse json", e);
        }
    }

    public static <T> T convertValue(Object value, Class<T> type) {
        return (T)OBJECT_MAPPER.convertValue(value, type);
    }

    public static byte[] toByteArray(Object value) {
        try {
            return OBJECT_MAPPER.writer().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize to json", e);
        }
    }

    public static String toJson(Object value) {
        try {
            return OBJECT_MAPPER.writer().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize to json", e);
        }
    }
}

