/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.AbstractTemplateLoader;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import net.codestory.http.templating.Site;
import net.codestory.http.templating.Template;
import net.codestory.http.templating.helpers.EachReverseHelper;
import net.codestory.http.templating.helpers.EachValueHelperSource;

public class HandlebarsCompiler {
    public String compile(String template, Map<String, Object> variables) throws IOException {
        return this.compile(template, null, variables);
    }

    String compile(String template, Site site, Map<String, Object> variables) throws IOException {
        Handlebars handlebars = HandlebarsCompiler.createHandlebars(site, variables);
        Context context = site == null ? HandlebarsCompiler.context(null, variables).build() : HandlebarsCompiler.context(null, null).combine("site", (Object)site).combine(variables).build();
        return handlebars.compileInline(template, "[[", "]]").apply(context);
    }

    private static Handlebars createHandlebars(final Site site, final Map<String, Object> variables) {
        return new Handlebars().registerHelper("each_reverse", EachReverseHelper.INSTANCE).registerHelpers((Object)new EachValueHelperSource()).registerHelpers(StringHelpers.class).with(new TemplateLoader[]{new AbstractTemplateLoader(){

            public TemplateSource sourceAt(String location) {
                return new StringTemplateSource(location, new Template(Paths.get("_includes", location)).render(site, variables));
            }
        }});
    }

    private static Context.Builder context(Context parent, Object model) {
        Context.Builder builder = parent == null ? Context.newBuilder((Object)model) : Context.newBuilder((Context)parent, (Object)model);
        return builder.resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE, Site.SiteValueResolver.INSTANCE});
    }
}

