/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.Template;
import net.codestory.http.types.ContentTypes;
import org.simpleframework.http.Response;

public class Payload {
    private final String contentType;
    private final Object content;
    private final int code;
    private final Map<String, String> headers;

    public Payload(Object content) {
        this(null, content);
    }

    public Payload(String contentType, Object content) {
        this(contentType, content, 200);
    }

    public Payload(String contentType, Object content, int code) {
        this.contentType = contentType;
        this.content = content;
        this.code = code;
        this.headers = new LinkedHashMap<String, String>();
    }

    public static Payload wrap(Object payload) {
        return payload instanceof Payload ? (Payload)payload : new Payload(payload);
    }

    public static Payload seeOther(String url) {
        Payload payload = new Payload(null, null, 303);
        payload.headers.put("Location", url);
        return payload;
    }

    public static Payload movedPermanently(String url) {
        Payload payload = new Payload(null, null, 301);
        payload.headers.put("Location", url);
        return payload;
    }

    public static Payload forbidden() {
        return new Payload(null, null, 403);
    }

    public int code() {
        return this.code;
    }

    public void writeTo(Response response) throws IOException {
        this.headers.entrySet().forEach(entry -> response.setValue((String)entry.getKey(), (String)entry.getValue()));
        response.setCode(this.code);
        byte[] data = this.getData();
        if (data != null) {
            response.setValue("Content-Type", this.getContentType());
            response.setContentLength((long)data.length);
            response.getOutputStream().write(data);
        } else {
            response.setContentLength(0L);
        }
    }

    String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (this.content instanceof File) {
            File file = (File)this.content;
            return ContentTypes.get(file.toPath());
        }
        if (this.content instanceof Path) {
            Path path = (Path)this.content;
            return ContentTypes.get(path);
        }
        if (this.content instanceof byte[]) {
            return "application/octet-stream";
        }
        if (this.content instanceof InputStream) {
            return "application/octet-stream";
        }
        if (this.content instanceof String) {
            return "text/html";
        }
        return "application/json";
    }

    byte[] getData() throws IOException {
        if (this.content == null) {
            return null;
        }
        if (this.content instanceof File) {
            return Payload.forPath(((File)this.content).toPath());
        }
        if (this.content instanceof Path) {
            return Payload.forPath((Path)this.content);
        }
        if (this.content instanceof byte[]) {
            return (byte[])this.content;
        }
        if (this.content instanceof String) {
            return Payload.forString((String)this.content);
        }
        if (this.content instanceof InputStream) {
            return Payload.forInputStream((InputStream)this.content);
        }
        return new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).writer().writeValueAsBytes(this.content);
    }

    private static byte[] forString(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] forInputStream(InputStream stream) throws IOException {
        return InputStreams.readBytes(stream);
    }

    private static byte[] forPath(Path path) throws IOException {
        if (ContentTypes.is_binary(path)) {
            return Resources.readBytes(path);
        }
        if (!ContentTypes.support_templating(path)) {
            String content = Resources.read(path, StandardCharsets.UTF_8);
            return Payload.forString(Compiler.compile(path, content));
        }
        return Payload.forString(new Template(path).render());
    }
}

