/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.ssl;

import java.io.ByteArrayInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class SSLContextFactory {
    public SSLContext create(List<Path> pathCertificate, Path pathPrivateKey) throws Exception {
        Certificate[] chain = (X509Certificate[])pathCertificate.stream().map(path -> {
            try {
                return SSLContextFactory.generateCertificateFromDER(Files.readAllBytes(path));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).toArray(X509Certificate[]::new);
        RSAPrivateKey key = SSLContextFactory.generatePrivateKeyFromDER(Files.readAllBytes(pathPrivateKey));
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setCertificateEntry("cert-alias", chain[0]);
        keystore.setKeyEntry("key-alias", key, new char[0], chain);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(SSLContextFactory.getKeyManagers(keystore), null, null);
        return context;
    }

    private static KeyManager[] getKeyManagers(KeyStore keyStore) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, new char[0]);
        return kmf.getKeyManagers();
    }

    private static X509Certificate generateCertificateFromDER(byte[] data) throws CertificateException {
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(data));
    }

    private static RSAPrivateKey generatePrivateKeyFromDER(byte[] data) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(data));
    }
}

