/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

public enum Env {
    INSTANCE;

    private final boolean prodMode = Env.getBoolean("PROD_MODE", false);
    private final boolean disableClassPath = Env.getBoolean("http.disable.classpath", false);
    private final boolean disableFilesystem = Env.getBoolean("http.disable.filesystem", false);
    private final boolean disableGzip = Env.getBoolean("http.disable.gzip", false);

    public boolean prodMode() {
        return this.prodMode;
    }

    public int overriddenPort(int port) {
        return Env.getInt("PORT", Env.getInt("app.port", port));
    }

    public boolean disableClassPath() {
        return this.disableClassPath;
    }

    public boolean disableFilesystem() {
        return this.disableFilesystem;
    }

    public boolean disableGzip() {
        return this.disableGzip;
    }

    private static String get(String propertyName) {
        String env = System.getenv(propertyName);
        return env != null ? env : System.getProperty(propertyName);
    }

    private static boolean getBoolean(String propertyName, boolean defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private static int getInt(String propertyName, int defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Integer.parseInt(value);
    }
}

