/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.basic;

import java.io.IOException;
import java.util.Map;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.internal.Context;
import net.codestory.http.payload.Payload;
import net.codestory.http.security.User;
import net.codestory.http.security.Users;
import org.simpleframework.http.parse.PrincipalParser;

public class BasicAuthFilter
implements Filter {
    private final String uriPrefix;
    private final String realm;
    private final Users users;

    public BasicAuthFilter(String uriPrefix, String realm, Users users) {
        this.uriPrefix = uriPrefix;
        this.realm = realm;
        this.users = users;
    }

    public BasicAuthFilter(String uriPrefix, String realm, Map<String, String> users) {
        this(uriPrefix, realm, Users.forMap(users));
    }

    @Override
    public boolean matches(String uri, Context context) {
        return uri.startsWith(this.uriPrefix);
    }

    @Override
    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws IOException {
        String authorization = context.getHeader("Authorization");
        if (authorization == null) {
            return Payload.unauthorized(this.realm);
        }
        PrincipalParser parser = new PrincipalParser(authorization);
        User user = this.users.find(parser.getName(), parser.getPassword());
        if (user == null) {
            return Payload.unauthorized(this.realm);
        }
        context.setCurrentUser(user);
        return nextFilter.get().withHeader("Cache-Control", "must-revalidate");
    }
}

