/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.sommeri.less4j.LessSource;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.io.Resources;

class PathSource
extends LessSource {
    private final Path path;
    private final String content;

    PathSource(Path path, String content) {
        this.path = path;
        this.content = content;
    }

    public LessSource relativeSource(String filename) throws LessSource.CannotReadFile, LessSource.FileNotFound {
        if (filename.startsWith("/webjars/")) {
            URL webjarResource = Resources.getResource("META-INF/resources" + filename);
            if (webjarResource == null) {
                throw new LessSource.FileNotFound();
            }
            return new LessSource.URLSource(webjarResource);
        }
        Path relativePath = Paths.get(filename, new String[0]);
        if (!Resources.exists(relativePath)) {
            throw new LessSource.FileNotFound();
        }
        try {
            String includeContent = Resources.read(relativePath, StandardCharsets.UTF_8);
            return new PathSource(relativePath, includeContent);
        }
        catch (IOException e) {
            throw new LessSource.CannotReadFile();
        }
    }

    public String getName() {
        return Resources.toUnixString(this.path);
    }

    public String getContent() {
        return this.content;
    }

    public byte[] getBytes() throws LessSource.CannotReadFile, LessSource.FileNotFound {
        if (!Resources.exists(this.path)) {
            throw new LessSource.FileNotFound();
        }
        try {
            return Resources.readBytes(this.path);
        }
        catch (IOException e) {
            throw new LessSource.CannotReadFile();
        }
    }
}

