/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Resources;

public final class NashornCompiler {
    private final CompiledScript compiledScript;
    private final Bindings bindings;

    NashornCompiler(String ... scriptPaths) {
        String script = this.readScripts(scriptPaths);
        ScriptEngine nashorn = new ScriptEngineManager().getEngineByName("nashorn");
        try {
            this.compiledScript = ((Compilable)((Object)nashorn)).compile(script);
            this.bindings = nashorn.getBindings(100);
        }
        catch (ScriptException e) {
            throw new IllegalStateException("Unable to compile javascript", e);
        }
    }

    private String readScripts(String ... scriptPaths) {
        StringBuilder concatenatedScript = new StringBuilder();
        for (String scriptPath : scriptPaths) {
            try (InputStream input = Resources.getResourceAsStream(scriptPath);){
                String content = InputStreams.readString(input, StandardCharsets.UTF_8);
                concatenatedScript.append(content).append("\n");
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read script " + scriptPath, e);
            }
        }
        return concatenatedScript.toString();
    }

    public synchronized String compile(String source) throws IOException {
        this.bindings.put("__source", (Object)source);
        try {
            return this.compiledScript.eval(this.bindings).toString();
        }
        catch (ScriptException e) {
            throw new IOException("Unable to compile", e);
        }
    }
}

