/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.codestory.http.compilers.AsciidocCompiler;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.CoffeeCompiler;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.DiskCache;
import net.codestory.http.compilers.LessCompiler;
import net.codestory.http.compilers.LessSourceMapCompiler;
import net.codestory.http.compilers.MarkdownCompiler;
import net.codestory.http.misc.MemoizingSupplier;

public enum Compilers {
    INSTANCE;

    private final Map<String, Supplier<Compiler>> compilerByExtension = new HashMap<String, Supplier<Compiler>>();
    private final ConcurrentMap<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private final DiskCache diskCache = new DiskCache("V1");

    private Compilers() {
        this.register(CoffeeCompiler::new, ".coffee", ".litcoffee");
        this.register(MarkdownCompiler::new, ".md", ".markdown");
        this.register(LessCompiler::new, ".less", new String[0]);
        this.register(LessSourceMapCompiler::new, ".css.map", new String[0]);
        this.register(AsciidocCompiler::new, ".asciidoc", ".adoc");
    }

    public void register(Supplier<Compiler> compilerFactory, String firstExtension, String ... moreExtensions) {
        Supplier<Compiler> compilerLazyFactory = MemoizingSupplier.memoize(compilerFactory);
        this.compilerByExtension.put(firstExtension, compilerLazyFactory);
        for (String extension : moreExtensions) {
            this.compilerByExtension.put(extension, compilerLazyFactory);
        }
    }

    public CacheEntry compile(Path path, String content) {
        return this.cache.computeIfAbsent(path.toString() + ";" + content, ignore -> this.doCompile(path, content));
    }

    private CacheEntry doCompile(Path path, String content) {
        for (Map.Entry<String, Supplier<Compiler>> entry : this.compilerByExtension.entrySet()) {
            String extension = entry.getKey();
            if (!path.toString().endsWith(extension)) continue;
            return this.diskCache.computeIfAbsent(path, content, entry.getValue(), extension);
        }
        return CacheEntry.memory(content);
    }
}

