/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import net.codestory.http.Configuration;
import net.codestory.http.reload.FolderWatcher;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReloadingRoutesProvider
implements RoutesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadingRoutesProvider.class);
    private final Configuration configuration;
    private final AtomicBoolean dirty;
    private final FolderWatcher targetFolderWatcher;
    private final FolderWatcher appFolderWatcher;
    private RouteCollection routes;

    ReloadingRoutesProvider(Configuration configuration) {
        this.configuration = configuration;
        this.dirty = new AtomicBoolean(true);
        this.targetFolderWatcher = new FolderWatcher(Paths.get("target/classes/", new String[0]), ev -> this.dirty.set(true));
        this.appFolderWatcher = new FolderWatcher(Paths.get("app", new String[0]), ev -> System.out.println("Change detected in app folder"));
    }

    @Override
    public synchronized RouteCollection get() {
        if (this.dirty.get()) {
            LOG.info("Reloading configuration...");
            this.targetFolderWatcher.ensureStarted();
            this.routes = new RouteCollection();
            this.configuration.configure(this.routes);
            this.routes.addStaticRoutes();
            this.dirty.set(false);
        }
        return this.routes;
    }
}

