/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.auth;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.internal.Context;
import net.codestory.http.misc.Fluent;
import net.codestory.http.payload.Payload;
import net.codestory.http.security.SessionIdStore;
import net.codestory.http.security.User;
import net.codestory.http.security.Users;
import org.apache.commons.lang3.RandomStringUtils;
import org.simpleframework.http.Cookie;

public class CookieAuthFilter
implements Filter {
    private static final int ONE_DAY = (int)TimeUnit.DAYS.toSeconds(1L);
    private static final String[] DEFAULT_EXCLUDE = new String[]{".less", ".css", ".map", ".js", ".coffee", ".ico", ".jpeg", ".jpg", ".gif", ".png", ".svg", ".eot", ".ttf", ".woff", ".js", ".coffee"};
    private final String uriPrefix;
    private final Users users;
    private final SessionIdStore sessionIdStore;
    private final String[] ignoreExtensions;

    public CookieAuthFilter(String uriPrefix, Users users) {
        this(uriPrefix, users, SessionIdStore.inMemory(), DEFAULT_EXCLUDE);
    }

    public CookieAuthFilter(String uriPrefix, Users users, SessionIdStore sessionIdStore) {
        this(uriPrefix, users, sessionIdStore, DEFAULT_EXCLUDE);
    }

    public CookieAuthFilter(String uriPrefix, Users users, SessionIdStore sessionIdStore, String ignoreExtension, String ... moreIgnoreExtensions) {
        this(uriPrefix, users, sessionIdStore, Fluent.of(ignoreExtension).concat((String[])moreIgnoreExtensions).toArray(String[]::new));
    }

    private CookieAuthFilter(String uriPrefix, Users users, SessionIdStore sessionIdStore, String[] ignoreExtensions) {
        this.uriPrefix = uriPrefix;
        this.users = users;
        this.sessionIdStore = sessionIdStore;
        this.ignoreExtensions = ignoreExtensions;
    }

    @Override
    public boolean matches(String uri, Context context) {
        if (!uri.startsWith(this.uriPrefix)) {
            return false;
        }
        for (String ignoreExtension : this.ignoreExtensions) {
            if (!uri.endsWith(ignoreExtension)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws IOException {
        String login;
        String method = context.method();
        if (uri.equals("/auth/login") && method.equals("GET")) {
            return nextFilter.get();
        }
        if (uri.equals("/auth/signin") && method.equals("POST")) {
            String password;
            String login2 = context.get("login");
            if (this.users.find(login2, password = context.get("password")) == null) {
                return Payload.seeOther("/auth/login");
            }
            String sessionId = this.create(login2);
            return Payload.seeOther(CookieAuthFilter.notFavIcon(context.cookieValue("redirectAfterLogin", "/"))).withCookie(CookieAuthFilter.loginCookie(login2)).withCookie(CookieAuthFilter.sessionCookie(sessionId)).withCookie(CookieAuthFilter.redirectUrlCookie("/"));
        }
        if (uri.equals("/auth/signout") && method.equals("GET")) {
            String sessionId = context.cookieValue("sessionId", "");
            this.sessionIdStore.remove(sessionId);
            return Payload.seeOther("/?signout").withCookie(CookieAuthFilter.loginCookie(null)).withCookie(CookieAuthFilter.sessionCookie(null)).withCookie(CookieAuthFilter.redirectUrlCookie(null));
        }
        if (uri.startsWith("/auth/")) {
            return nextFilter.get();
        }
        String sessionId = context.cookieValue("sessionId");
        if (sessionId != null && (login = this.sessionIdStore.getLogin(sessionId)) != null) {
            User user = this.users.find(login);
            context.setCurrentUser(user);
            return nextFilter.get().withHeader("Cache-Control", "must-revalidate");
        }
        return Payload.seeOther("/auth/login").withCookie(CookieAuthFilter.loginCookie(null)).withCookie(CookieAuthFilter.sessionCookie(null)).withCookie(CookieAuthFilter.redirectUrlCookie(uri));
    }

    private String create(String login) {
        String sessionId = RandomStringUtils.random((int)32, (boolean)true, (boolean)true);
        this.sessionIdStore.put(sessionId, login);
        return sessionId;
    }

    private static Cookie loginCookie(String login) {
        return CookieAuthFilter.expire(new Cookie("login", login, "/", true));
    }

    private static Cookie sessionCookie(String sessionId) {
        return CookieAuthFilter.expire(new Cookie("sessionId", sessionId, "/", true));
    }

    private static Cookie redirectUrlCookie(String uri) {
        return CookieAuthFilter.expire(new Cookie("redirectAfterLogin", uri, "/", true));
    }

    private static Cookie expire(Cookie cookie) {
        cookie.setExpiry(ONE_DAY);
        cookie.setDomain(null);
        cookie.setSecure(false);
        return cookie;
    }

    private static String notFavIcon(String redirectUrl) {
        return redirectUrl.contains("favicon.ico") ? "/" : redirectUrl;
    }
}

