/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import net.codestory.http.Payload;
import net.codestory.http.UriParser;
import net.codestory.http.annotations.Get;
import net.codestory.http.annotations.Post;
import net.codestory.http.filters.Filter;
import net.codestory.http.routes.AnyGetRoute;
import net.codestory.http.routes.AnyPostRoute;
import net.codestory.http.routes.FourParamsGetRoute;
import net.codestory.http.routes.FourParamsPostRoute;
import net.codestory.http.routes.GetRouteWrapper;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.NoParamGetRoute;
import net.codestory.http.routes.NoParamPostRoute;
import net.codestory.http.routes.OneParamGetRoute;
import net.codestory.http.routes.OneParamPostRoute;
import net.codestory.http.routes.PostRouteWrapper;
import net.codestory.http.routes.ReflectionGetRoute;
import net.codestory.http.routes.ReflectionPostRoute;
import net.codestory.http.routes.Route;
import net.codestory.http.routes.Routes;
import net.codestory.http.routes.StaticRoute;
import net.codestory.http.routes.ThreeParamsGetRoute;
import net.codestory.http.routes.ThreeParamsPostRoute;
import net.codestory.http.routes.TwoParamsGetRoute;
import net.codestory.http.routes.TwoParamsPostRoute;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

public class RouteCollection
implements Routes {
    private final Deque<Route> routes = new LinkedList<Route>();
    private final Deque<Filter> filters = new LinkedList<Filter>();

    @Override
    public void add(Object resource) {
        this.add("", resource);
    }

    @Override
    public void add(String urlPrefix, Object resource) {
        Class<?> type = resource.getClass();
        if (resource.getClass().getName().contains("EnhancerByMockito")) {
            type = type.getSuperclass();
        }
        for (Method method : type.getMethods()) {
            int uriParamsCount;
            String uriPattern;
            int parameterCount = method.getParameterCount();
            for (Get get : (Get[])method.getDeclaredAnnotationsByType(Get.class)) {
                uriPattern = urlPrefix + get.value();
                uriParamsCount = UriParser.paramsCount(uriPattern);
                if (parameterCount == uriParamsCount) {
                    this.add("GET", RouteCollection.checkParametersCount(uriPattern, parameterCount), new ReflectionGetRoute(resource, method));
                    continue;
                }
                if (parameterCount == uriParamsCount + 1) {
                    this.add("GET", RouteCollection.checkParametersCount(uriPattern, parameterCount - 1), new ReflectionPostRoute(resource, method));
                    continue;
                }
                throw new IllegalArgumentException("Expected " + uriParamsCount + " or " + (uriParamsCount + 1) + " parameters in " + uriPattern);
            }
            for (Annotation annotation : (Post[])method.getDeclaredAnnotationsByType(Post.class)) {
                uriPattern = urlPrefix + annotation.value();
                uriParamsCount = UriParser.paramsCount(uriPattern);
                if (parameterCount == uriParamsCount) {
                    this.add("POST", RouteCollection.checkParametersCount(uriPattern, parameterCount), new ReflectionGetRoute(resource, method));
                    continue;
                }
                if (parameterCount == uriParamsCount + 1) {
                    this.add("POST", RouteCollection.checkParametersCount(uriPattern, parameterCount - 1), new ReflectionPostRoute(resource, method));
                    continue;
                }
                throw new IllegalArgumentException("Expected " + uriParamsCount + " or " + (uriParamsCount + 1) + " parameters in " + uriPattern);
            }
        }
    }

    @Override
    public void get(String uriPattern, Payload payload) {
        this.get(uriPattern, () -> payload);
    }

    @Override
    public void get(String uriPattern, NoParamGetRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void get(String uriPattern, OneParamGetRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void get(String uriPattern, TwoParamsGetRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void get(String uriPattern, ThreeParamsGetRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void get(String uriPattern, FourParamsGetRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void post(String uriPattern, NoParamPostRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void post(String uriPattern, OneParamPostRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void post(String uriPattern, TwoParamsPostRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void post(String uriPattern, ThreeParamsPostRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void post(String uriPattern, FourParamsPostRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void filter(Filter filter) {
        this.filters.addLast(filter);
    }

    public void reset() {
        this.routes.clear();
        this.filters.clear();
    }

    private void add(String method, String uriPattern, AnyGetRoute route) {
        this.routes.addFirst(new GetRouteWrapper(method, uriPattern, route));
    }

    private void add(String method, String uriPattern, AnyPostRoute route) {
        this.routes.addFirst(new PostRouteWrapper(method, uriPattern, route));
    }

    public Match apply(Request request, Response response) throws IOException {
        String uri = request.getPath().getPath();
        if (uri == null) {
            return Match.WRONG_URL;
        }
        for (Filter filter : this.filters) {
            if (!filter.apply(uri, request, response)) continue;
            return Match.OK;
        }
        Match bestMatch = Match.WRONG_URL;
        ArrayList<Route> allRoutes = new ArrayList<Route>();
        allRoutes.addAll(this.routes);
        allRoutes.add(new StaticRoute());
        for (Route route : allRoutes) {
            Match match = route.apply(uri, request, response);
            if (match == Match.OK) {
                return Match.OK;
            }
            if (!match.isBetter(bestMatch)) continue;
            bestMatch = match;
        }
        return bestMatch;
    }

    private static String checkParametersCount(String uriPattern, int count) {
        if (UriParser.paramsCount(uriPattern) != count) {
            throw new IllegalArgumentException("Expected " + count + " parameters in " + uriPattern);
        }
        return uriPattern;
    }
}

