/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.util.Map;
import net.codestory.http.Payload;
import net.codestory.http.UriParser;
import net.codestory.http.routes.AnyGetRoute;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.Route;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

class GetRouteWrapper
implements Route {
    private final String method;
    private final UriParser uriParser;
    private final AnyGetRoute route;

    GetRouteWrapper(String method, String uriPattern, AnyGetRoute route) {
        this.method = method;
        this.uriParser = new UriParser(uriPattern);
        this.route = route;
    }

    @Override
    public Match apply(String uri, Request request, Response response) throws IOException {
        if (!this.uriParser.matches(uri)) {
            return Match.WRONG_URL;
        }
        if (!this.method.equalsIgnoreCase(request.getMethod())) {
            return Match.WRONG_METHOD;
        }
        String[] parameters = this.uriParser.params(uri, (Map<String, String>)request.getQuery());
        Object body = this.route.body(parameters);
        Payload payload = Payload.wrap(body);
        payload.writeTo(response);
        return Match.OK;
    }
}

