/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.convert;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;

public class TypeConvert {
    private TypeConvert() {
    }

    public static Object[] convert(Map<String, String> keyValues, String[] values, Class<?>[] types) {
        Object[] converted = new Object[values.length + 1];
        converted[0] = TypeConvert.convert(keyValues, types[0]);
        for (int i = 0; i < values.length; ++i) {
            converted[i + 1] = TypeConvert.convert(values[i], types[i]);
        }
        return converted;
    }

    public static Object[] convert(String[] values, Class<?>[] types) {
        Object[] converted = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            converted[i] = TypeConvert.convert(values[i], types[i]);
        }
        return converted;
    }

    public static Object convert(String value, Class<?> type) {
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }

    public static Object convert(Map<String, String> keyValues, Class<?> type) {
        if (type.isAssignableFrom(Map.class)) {
            return keyValues;
        }
        return new ObjectMapper().convertValue(keyValues, type);
    }
}

