/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.codestory.http.annotations.Produces;
import net.codestory.http.internal.Context;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.AnyRoute;

abstract class AbstractReflectionRoute
implements AnyRoute {
    private final Supplier<Object> resource;
    private final Method method;

    protected AbstractReflectionRoute(Supplier<Object> resource, Method method) {
        this.resource = resource;
        this.method = method;
    }

    @Override
    public Object body(Context context, String[] pathParameters) {
        try {
            Object[] arguments = this.findArguments(context, pathParameters, this.method.getParameterTypes());
            Object target = this.resource.get();
            Object response = AbstractReflectionRoute.invoke(this.method, target, arguments);
            Object payload = AbstractReflectionRoute.emptyIfNull(response);
            String contentType = AbstractReflectionRoute.findContentType(this.method);
            return new Payload(contentType, payload);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to apply route", e);
        }
    }

    protected abstract Object[] findArguments(Context var1, String[] var2, Class<?>[] var3);

    private static Object invoke(Method method, Object target, Object[] arguments) throws Throwable {
        try {
            method.setAccessible(true);
            return method.invoke(target, arguments);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static Object emptyIfNull(Object payload) {
        return payload == null ? "" : payload;
    }

    private static String findContentType(Method method) {
        Produces annotation = method.getAnnotation(Produces.class);
        return annotation == null ? null : annotation.value();
    }
}

