/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.cache.ConcurrentMapTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.AbstractTemplateLoader;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.util.Map;
import net.codestory.http.templating.Site;
import net.codestory.http.templating.Template;
import net.codestory.http.templating.helpers.EachReverseHelperSource;
import net.codestory.http.templating.helpers.EachValueHelperSource;

public class HandlebarsCompiler {
    public String compile(String template, Map<String, Object> variables) throws IOException {
        return HandlebarsCompiler.handlebars(variables).compileInline(template).apply(HandlebarsCompiler.context(variables));
    }

    private static Handlebars handlebars(final Map<String, Object> variables) {
        Handlebars hb = new Handlebars();
        hb.startDelimiter("[[");
        hb.endDelimiter("]]");
        hb.registerHelpers((Object)new EachReverseHelperSource());
        hb.registerHelpers((Object)new EachValueHelperSource());
        hb.registerHelpers(StringHelpers.class);
        hb.with((TemplateCache)new ConcurrentMapTemplateCache());
        hb.with(new TemplateLoader[]{new AbstractTemplateLoader(){

            public TemplateSource sourceAt(String location) {
                return new StringTemplateSource(location, new Template("_includes", location).render(variables).content());
            }
        }});
        if (HandlebarsCompiler.isThereACustomHandleBarHelperToLoad()) {
            hb.registerHelpers(HandlebarsCompiler.findHandleBarHelpers());
        }
        return hb;
    }

    private static boolean isThereACustomHandleBarHelperToLoad() {
        return null != Site.get().get("handleBarHelper");
    }

    private static Class<?> findHandleBarHelpers() {
        String helperClassName = (String)Site.get().get("handleBarHelper");
        try {
            return Class.forName(helperClassName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to register " + helperClassName);
        }
    }

    private static Context context(Map<String, Object> variables) {
        return Context.newBuilder(null).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE, MethodValueResolver.INSTANCE, Site.SiteValueResolver.INSTANCE}).combine("site", (Object)Site.get()).combine(variables).build();
    }

    private static class NopRegister {
        private NopRegister() {
        }
    }
}

