/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import net.codestory.http.io.InputStreams;

public interface CacheEntry {
    public String content();

    public byte[] toBytes();

    public long lastModified();

    public static CacheEntry disk(final File file) {
        return new CacheEntry(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String content() {
                try (FileInputStream input = new FileInputStream(file);){
                    String string = InputStreams.readString(input, StandardCharsets.UTF_8);
                    return string;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to read file", e);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public byte[] toBytes() {
                try (FileInputStream input = new FileInputStream(file);){
                    byte[] byArray = InputStreams.readBytes(input);
                    return byArray;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to read file", e);
                }
            }

            @Override
            public long lastModified() {
                return file.lastModified();
            }
        };
    }

    public static CacheEntry memory(final String content) {
        return new CacheEntry(){
            private final long lastModified = System.currentTimeMillis();

            @Override
            public String content() {
                return content;
            }

            @Override
            public byte[] toBytes() {
                return content.getBytes(StandardCharsets.UTF_8);
            }

            @Override
            public long lastModified() {
                return this.lastModified;
            }
        };
    }
}

