/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.HandlebarsCompiler;
import net.codestory.http.templating.Model;
import net.codestory.http.templating.YamlFrontMatter;

public class Template {
    private final Path path;

    public Template(String folder, String name) {
        this(folder + (name.startsWith("/") ? name : "/" + name));
    }

    public Template(String uri) {
        Path existing = Resources.findExistingPath(uri);
        if (existing == null) {
            throw new IllegalArgumentException("Template not found " + uri);
        }
        this.path = existing;
    }

    public String renderAsString() {
        return this.render().content();
    }

    public String renderAsString(Model model) {
        return this.render(model).content();
    }

    public CacheEntry render() {
        return this.render(Collections.emptyMap());
    }

    public CacheEntry render(Model model) {
        return this.render(model.getKeyValues());
    }

    CacheEntry render(Map<String, Object> keyValues) {
        try {
            YamlFrontMatter yamlFrontMatter = YamlFrontMatter.parse(this.path);
            String content = yamlFrontMatter.getContent();
            Map<String, Object> variables = yamlFrontMatter.getVariables();
            Map<String, Object> allKeyValues = Template.merge(variables, keyValues);
            String body = new HandlebarsCompiler().compile(content, allKeyValues);
            String layout = (String)variables.get("layout");
            if (layout != null) {
                body = new Template("_layouts", layout).render(allKeyValues).content().replace("[[body]]", body);
            }
            return Compilers.INSTANCE.compile(this.path, body);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to render template", e);
        }
    }

    private static Map<String, Object> merge(Map<String, Object> first, Map<String, Object> second) {
        HashMap<String, Object> merged = new HashMap<String, Object>();
        merged.putAll(first);
        merged.putAll(second);
        merged.put("body", "[[body]]");
        return merged;
    }
}

