/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import net.codestory.http.internal.Context;
import net.codestory.http.io.InputStreams;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;

class WebJarsRoute
implements Route {
    private final boolean useMinifiedVersions;

    public WebJarsRoute(boolean useMinifiedVersions) {
        this.useMinifiedVersions = useMinifiedVersions;
    }

    @Override
    public boolean matchUri(String uri) {
        return uri.startsWith("/webjars/") && WebJarsRoute.getResource(uri) != null;
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Object body(Context context) throws IOException {
        String uri = context.uri();
        if (context.getHeader("If-Modified-Since") != null) {
            return Payload.notModified();
        }
        URL classpathUrl = WebJarsRoute.getResource(uri);
        try (InputStream stream = classpathUrl.openStream();){
            String contentType = ContentTypes.get(Paths.get(uri, new String[0]));
            byte[] data = InputStreams.readBytes(stream);
            Payload payload = new Payload(contentType, data).withHeader("Cache-Control", "public, max-age=31536000").withHeader("Last-Modified", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now().minusMonths(1L))).withHeader("Expires", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now().plusWeeks(1L)));
            return payload;
        }
    }

    private static URL getResource(String uri) {
        return ClassLoader.getSystemResource("META-INF/resources" + uri);
    }

    URL findUrl(String path) {
        URL urlMinified = WebJarsRoute.getResource(WebJarsRoute.minified(path));
        URL urlNonMinified = WebJarsRoute.getResource(WebJarsRoute.notMinified(path));
        if (this.useMinifiedVersions) {
            return urlMinified != null ? urlMinified : urlNonMinified;
        }
        return urlNonMinified != null ? urlNonMinified : urlMinified;
    }

    private static String minified(String path) {
        return path.contains(".min.") ? path : path.replace(".js", ".min.js").replace(".css", ".min.css");
    }

    private static String notMinified(String path) {
        return path.replace(".min.", ".");
    }
}

