/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.codestory.http.internal.Context;
import net.codestory.http.io.Resources;
import net.codestory.http.misc.Env;
import net.codestory.http.routes.Route;

class StaticRoute
implements Route {
    private final ConcurrentMap<String, Path> pathForUri = new ConcurrentHashMap<String, Path>(10);
    private static final Path NOT_FOUND = Paths.get("", new String[0]);

    StaticRoute() {
    }

    @Override
    public boolean matchUri(String uri) {
        Path result = Env.INSTANCE.devMode() ? StaticRoute.findPath(uri) : this.pathForUri.computeIfAbsent(uri, StaticRoute::findPath);
        return result != NOT_FOUND;
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Object body(Context context) {
        String uri = context.uri();
        if (Env.INSTANCE.devMode()) {
            return StaticRoute.findPath(uri);
        }
        return this.pathForUri.computeIfAbsent(uri, StaticRoute::findPath);
    }

    private static Path findPath(String uri) {
        Path path = Resources.findExistingPath(uri);
        return path != null && Resources.isPublic(path) ? path : NOT_FOUND;
    }
}

