/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.util.Map;
import net.codestory.http.internal.Context;
import net.codestory.http.internal.UriParser;
import net.codestory.http.routes.AnyRoute;
import net.codestory.http.routes.Route;

class RouteWrapper
implements Route {
    private final String method;
    private final UriParser uriParser;
    private final AnyRoute route;

    RouteWrapper(String method, String uriPattern, AnyRoute route) {
        this.method = method;
        this.uriParser = new UriParser(uriPattern);
        this.route = route;
    }

    @Override
    public boolean matchUri(String uri) {
        return this.uriParser.matches(uri);
    }

    @Override
    public boolean matchMethod(String method) {
        return this.method.equalsIgnoreCase(method);
    }

    @Override
    public Object body(Context context) {
        String[] parameters = this.uriParser.params(context.uri(), (Map<String, String>)context.request().getQuery());
        return this.route.body(context, parameters);
    }
}

