/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.codestory.http.Configuration;
import net.codestory.http.annotations.Delete;
import net.codestory.http.annotations.Get;
import net.codestory.http.annotations.Post;
import net.codestory.http.annotations.Put;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.injection.IocAdapter;
import net.codestory.http.injection.Singletons;
import net.codestory.http.internal.Context;
import net.codestory.http.internal.UriParser;
import net.codestory.http.misc.Env;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.AnyRoute;
import net.codestory.http.routes.CatchAllRoute;
import net.codestory.http.routes.FourParamsRoute;
import net.codestory.http.routes.NoParamRoute;
import net.codestory.http.routes.NoParamRouteWithContext;
import net.codestory.http.routes.OneParamRoute;
import net.codestory.http.routes.ReflectionRoute;
import net.codestory.http.routes.ReflectionRouteWithContext;
import net.codestory.http.routes.Route;
import net.codestory.http.routes.RouteWrapper;
import net.codestory.http.routes.Routes;
import net.codestory.http.routes.RoutesWithPattern;
import net.codestory.http.routes.SourceMapRoute;
import net.codestory.http.routes.StaticRoute;
import net.codestory.http.routes.ThreeParamsRoute;
import net.codestory.http.routes.TwoParamsRoute;
import net.codestory.http.routes.WebJarsRoute;

public class RouteCollection
implements Routes {
    private final List<Route> routes;
    private final List<Supplier<Filter>> filters;
    private IocAdapter iocAdapter = new Singletons();

    public RouteCollection() {
        this.routes = new LinkedList<Route>();
        this.filters = new LinkedList<Supplier<Filter>>();
    }

    @Override
    public RouteCollection setIocAdapter(IocAdapter iocAdapter) {
        this.iocAdapter = iocAdapter;
        return this;
    }

    @Override
    public RouteCollection include(Class<? extends Configuration> configurationClass) {
        this.iocAdapter.get(configurationClass).configure(this);
        return this;
    }

    @Override
    public RouteCollection include(Configuration configuration) {
        configuration.configure(this);
        return this;
    }

    @Override
    public RouteCollection filter(Class<? extends Filter> filterClass) {
        this.filters.add(() -> (Filter)this.iocAdapter.get(filterClass));
        return this;
    }

    @Override
    public RouteCollection filter(Filter filter) {
        this.filters.add(() -> filter);
        return this;
    }

    @Override
    public RouteCollection add(Class<?> resourceType) {
        this.addResource("", resourceType, () -> this.iocAdapter.get(resourceType));
        return this;
    }

    @Override
    public RouteCollection add(String urlPrefix, Class<?> resourceType) {
        this.addResource(urlPrefix, resourceType, () -> this.iocAdapter.get(resourceType));
        return this;
    }

    @Override
    public RouteCollection add(Object resource) {
        this.addResource("", resource.getClass(), () -> resource);
        return this;
    }

    @Override
    public RouteCollection add(String urlPrefix, Object resource) {
        this.addResource(urlPrefix, resource.getClass(), () -> resource);
        return this;
    }

    private void addResource(String urlPrefix, Class<?> type, Supplier<Object> resource) {
        if (type.getName().contains("EnhancerByMockito")) {
            type = type.getSuperclass();
        }
        for (Method method : type.getMethods()) {
            Arrays.stream(method.getAnnotationsByType(Get.class)).forEach(get -> this.addResource("GET", method, resource, urlPrefix + get.value()));
            Arrays.stream(method.getAnnotationsByType(Post.class)).forEach(post -> this.addResource("POST", method, resource, urlPrefix + post.value()));
            Arrays.stream(method.getAnnotationsByType(Put.class)).forEach(put -> this.addResource("PUT", method, resource, urlPrefix + put.value()));
            Arrays.stream(method.getAnnotationsByType(Delete.class)).forEach(delete -> this.addResource("DELETE", method, resource, urlPrefix + delete.value()));
        }
    }

    private void addResource(String httpMethod, Method method, Supplier<Object> resource, String uriPattern) {
        int uriParamsCount;
        int methodParamsCount = method.getParameterCount();
        if (methodParamsCount == (uriParamsCount = UriParser.paramsCount(uriPattern))) {
            this.add(httpMethod, RouteCollection.checkParametersCount(uriPattern, methodParamsCount), new ReflectionRoute(resource, method));
        } else if (methodParamsCount == uriParamsCount + 1) {
            this.add(httpMethod, RouteCollection.checkParametersCount(uriPattern, methodParamsCount - 1), new ReflectionRouteWithContext(resource, method));
        } else {
            throw new IllegalArgumentException("Expected " + uriParamsCount + " or " + (uriParamsCount + 1) + " parameters in " + uriPattern);
        }
    }

    @Override
    public RouteCollection get(String uriPattern, Object payload) {
        this.get(uriPattern, () -> payload);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, NoParamRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, NoParamRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, OneParamRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, TwoParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, ThreeParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, FourParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, NoParamRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, NoParamRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, OneParamRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, TwoParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, ThreeParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, FourParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, NoParamRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, NoParamRouteWithContext route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, OneParamRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, TwoParamsRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, ThreeParamsRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, FourParamsRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, NoParamRoute route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, NoParamRouteWithContext route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, OneParamRoute route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, TwoParamsRoute route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, ThreeParamsRoute route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, FourParamsRoute route) {
        this.add("DELETE", RouteCollection.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection catchAll(Object payload) {
        this.catchAll(() -> payload);
        return this;
    }

    @Override
    public RouteCollection catchAll(NoParamRoute route) {
        this.routes.add(new CatchAllRoute(route));
        return this;
    }

    @Override
    public RouteCollection catchAll(NoParamRouteWithContext route) {
        this.routes.add(new CatchAllRoute(route));
        return this;
    }

    @Override
    public RoutesWithPattern with(String uriPattern) {
        return new RoutesWithPattern(this, uriPattern);
    }

    private RouteCollection add(String method, String uriPattern, AnyRoute route) {
        this.routes.add(new RouteWrapper(method, uriPattern, route));
        return this;
    }

    public void addStaticRoutes() {
        this.routes.add(new WebJarsRoute(!Env.INSTANCE.devMode()));
        this.routes.add(new StaticRoute());
        this.routes.add(new SourceMapRoute());
    }

    public Payload apply(Context context) throws IOException {
        String uri = context.uri();
        if (uri == null) {
            return Payload.notFound();
        }
        PayloadSupplier payloadSupplier = () -> {
            Payload bestMatch = Payload.notFound();
            for (Route route : this.routes) {
                Payload match = route.apply(uri, context);
                if (!match.isError()) {
                    return match;
                }
                if (!match.isBetter(bestMatch)) continue;
                bestMatch = match;
            }
            return bestMatch;
        };
        for (Supplier<Filter> filter : this.filters) {
            PayloadSupplier nextFilter = payloadSupplier;
            payloadSupplier = () -> ((Filter)filter.get()).apply(uri, context, nextFilter);
        }
        return payloadSupplier.get();
    }

    public IocAdapter getIocAdapter() {
        return this.iocAdapter;
    }

    private static String checkParametersCount(String uriPattern, int count) {
        if (UriParser.paramsCount(uriPattern) != count) {
            String error = count == 1 ? "1 parameter" : count + " parameters";
            throw new IllegalArgumentException("Expected " + error + " in " + uriPattern);
        }
        return uriPattern;
    }
}

