/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public interface FileVisitors {
    public static SimpleFileVisitor<Path> onFile(final FileAction action) {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                action.accept(file);
                return FileVisitResult.CONTINUE;
            }
        };
    }

    public static SimpleFileVisitor<Path> onDirectory(final FileAction action) {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attr) throws IOException {
                action.accept(dir);
                return FileVisitResult.CONTINUE;
            }
        };
    }

    public static interface FileAction {
        public void accept(Path var1) throws IOException;
    }
}

