/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.codestory.http.io.FileVisitors;
import net.codestory.http.io.Resources;

class ClassPaths {
    ClassPaths() {
    }

    static List<String> fromURL(URL url) {
        String protocol = url.getProtocol();
        String name = url.toExternalForm();
        if ("file".equals(protocol)) {
            try {
                File file = ClassPaths.getFile(url);
                return name.contains(".jar") ? ClassPaths.forJarFile(new JarFile(file)) : ClassPaths.forSystemDir(file);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            List<String> relativePaths;
            if ("jar".equals(protocol) && (relativePaths = ClassPaths.forJarUrl(url)) != null) {
                return relativePaths;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static File getFile(URL url) {
        String path;
        try {
            path = url.toURI().getSchemeSpecificPart();
            if (new File(path).exists()) {
                return new File(path);
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        try {
            path = URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8.displayName());
            if (path.contains(".jar!")) {
                path = path.substring(0, path.lastIndexOf(".jar!") + ".jar".length());
            }
            if (new File(path).exists()) {
                return new File(path);
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            path = url.toExternalForm();
            if (path.startsWith("jar:")) {
                path = path.substring("jar:".length());
            } else if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            if (path.contains(".jar!")) {
                path = path.substring(0, path.indexOf(".jar!") + ".jar".length());
            }
            if (new File(path).exists()) {
                return new File(path);
            }
            if (new File(path = path.replace("%20", " ")).exists()) {
                return new File(path);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static List<String> forJarUrl(URL url) throws IOException {
        try {
            URLConnection urlConnection = url.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                return ClassPaths.forJarFile(((JarURLConnection)urlConnection).getJarFile());
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        File file = ClassPaths.getFile(url);
        if (file == null) {
            return null;
        }
        return ClassPaths.forJarFile(new JarFile(file));
    }

    private static List<String> forJarFile(JarFile jarFile) {
        ArrayList<String> files = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            files.add(entry.getName());
        }
        return files;
    }

    private static List<String> forSystemDir(File file) throws IOException {
        if (file == null || !file.exists()) {
            return Collections.emptyList();
        }
        Path parent = file.toPath();
        ArrayList<String> files = new ArrayList<String>();
        Files.walkFileTree(parent, FileVisitors.onFile(path2 -> files.add(Resources.relativePath(parent, path2))));
        return files;
    }
}

