/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.injection.IocAdapter;
import net.codestory.http.io.InputStreams;
import org.simpleframework.http.Cookie;
import org.simpleframework.http.Query;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

public class Context {
    private final Request request;
    private final Response response;
    private final IocAdapter iocAdapter;
    private final Query query;
    private String currentUser;

    public Context(Request request, Response response, IocAdapter iocAdapter) {
        this.request = request;
        this.response = response;
        this.iocAdapter = iocAdapter;
        this.query = request.getQuery();
    }

    public String uri() {
        return this.request.getPath().getPath();
    }

    public Cookie cookie(String name) {
        return this.request.getCookie(name);
    }

    public String cookieValue(String name) {
        Cookie cookie = this.cookie(name);
        return cookie == null ? null : cookie.getValue();
    }

    public <T> T cookieValue(String name, T defaultValue) {
        Object value = this.cookieValue(name, defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }

    public <T> T cookieValue(String name, Class<T> type) {
        String value = this.cookieValue(name);
        return value == null ? null : (T)TypeConvert.fromJson(value, type);
    }

    public String cookieValue(String name, String defaultValue) {
        String value = this.cookieValue(name);
        return value == null ? defaultValue : value;
    }

    public int cookieValue(String name, int defaultValue) {
        String value = this.cookieValue(name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public long cookieValue(String name, long defaultValue) {
        String value = this.cookieValue(name);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public boolean cookieValue(String name, boolean defaultValue) {
        String value = this.cookieValue(name);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public List<Cookie> cookies() {
        return this.request.getCookies();
    }

    public String get(String name) {
        return (String)this.query.get((Object)name);
    }

    public List<String> getAll(String name) {
        return this.query.getAll((Object)name);
    }

    public int getInteger(String name) {
        return this.query.getInteger((Object)name);
    }

    public float getFloat(String name) {
        return this.query.getFloat((Object)name);
    }

    public boolean getBoolean(String name) {
        return this.query.getBoolean((Object)name);
    }

    public String getHeader(String name) {
        return this.request.getValue(name);
    }

    public List<String> getHeaders(String name) {
        return this.request.getValues(name);
    }

    public String method() {
        return this.request.getMethod();
    }

    public Map<String, String> keyValues() {
        return this.query;
    }

    public String getClientAddress() {
        String forwarded = this.getHeader("X-Forwarded-For");
        return forwarded != null ? forwarded : this.request.getClientAddress().toString();
    }

    public Request request() {
        return this.request;
    }

    public Response response() {
        return this.response;
    }

    public byte[] payload() {
        try {
            return InputStreams.readBytes(this.request.getInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read payload", e);
        }
    }

    public <T> T payload(Class<T> type) {
        return TypeConvert.convert(this, type);
    }

    public <T> T getBean(Class<T> type) {
        return this.iocAdapter.get(type);
    }

    public void setCurrentUser(String user) {
        this.currentUser = user;
    }

    public String currentUser() {
        return this.currentUser;
    }
}

